/*
 * Decompiled with CFR 0.152.
 */
package tipi.config;

import ch.sharedvd.tipi.engine.client.TipiFacade;
import ch.sharedvd.tipi.engine.client.TipiFacadeImpl;
import ch.sharedvd.tipi.engine.command.CommandConsumer;
import ch.sharedvd.tipi.engine.command.CommandHelperService;
import ch.sharedvd.tipi.engine.command.CommandService;
import ch.sharedvd.tipi.engine.command.CommandServiceImpl;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.query.ActivityQueryService;
import ch.sharedvd.tipi.engine.query.TipiQueryFacade;
import ch.sharedvd.tipi.engine.query.TipiQueryFacadeImpl;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.runner.ActivityRunningService;
import ch.sharedvd.tipi.engine.runner.ConnectionCap;
import ch.sharedvd.tipi.engine.runner.ConnectionCapManager;
import ch.sharedvd.tipi.engine.runner.TipiStarter;
import ch.sharedvd.tipi.engine.runner.TipiStarterImpl;
import ch.sharedvd.tipi.engine.runner.TopProcessGroupManager;
import ch.sharedvd.tipi.engine.svc.ActivityPersisterService;
import ch.sharedvd.tipi.engine.utils.BeanAutowirer;
import ch.sharedvd.tipi.engine.utils.TipiProperties;
import ch.sharedvd.tipi.engine.utils.TixTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ComponentScan(value={"ch.sharedvd.tipi.engine"})
@EntityScan(basePackageClasses={DbActivity.class})
@EnableJpaRepositories(basePackageClasses={ActivityRepository.class})
@Import(value={TipiProperties.class})
public class TipiAutoConfiguration {
    @Autowired
    private TipiProperties tipiProperties;

    @Bean
    public TixTemplate tixTemplate(PlatformTransactionManager ptm) {
        return new TixTemplate(ptm);
    }

    @Bean
    public BeanAutowirer beanAutowirer() {
        return new BeanAutowirer();
    }

    @Bean
    public TipiStarter tipiStarter() {
        TipiStarterImpl ts = new TipiStarterImpl();
        ts.setStartAtBoot(this.tipiProperties.isStartAtBoot());
        return ts;
    }

    @Bean
    public TipiQueryFacade tipiQueryFacade() {
        return new TipiQueryFacadeImpl();
    }

    @Bean
    public TipiFacade tipiFacade() {
        return new TipiFacadeImpl();
    }

    @Bean
    public ActivityRunningService activityService() {
        return new ActivityRunningService();
    }

    @Bean
    public ActivityPersisterService activityPersistenceService() {
        return new ActivityPersisterService();
    }

    @Bean
    public ActivityQueryService activityQueryService() {
        return new ActivityQueryService();
    }

    @Bean
    public CommandHelperService commandHelperService() {
        return new CommandHelperService();
    }

    @Bean
    public TopProcessGroupManager activityGroupManager() {
        return new TopProcessGroupManager();
    }

    @Bean
    public CommandConsumer commandConsumer() {
        CommandConsumer cc = new CommandConsumer();
        cc.setResumeTipiAtBoot(this.tipiProperties.isResumeAtBoot());
        return cc;
    }

    @Bean
    public CommandService commandService() {
        return new CommandServiceImpl();
    }

    @Bean
    public ConnectionCapManager connectionCapManager() {
        return new ConnectionCapManager();
    }

    @Bean
    public ConnectionCap defaultCap() {
        ConnectionCap cap = new ConnectionCap();
        cap.setName("DataSource");
        cap.setDescription("Limit on the datasource connections");
        cap.setNbMaxConcurrent(10);
        cap.setDefault(true);
        cap.setConnectionCapManager(this.connectionCapManager());
        return cap;
    }
}

