/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.command;

import ch.sharedvd.tipi.engine.command.Command;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.springframework.util.Assert;

public class CommandWrapper
implements Comparable<CommandWrapper> {
    private long sendTime;
    private Command command;
    private int nbRetry = 0;

    public CommandWrapper(Command cmd) {
        Assert.notNull((Object)cmd);
        this.command = cmd;
        this.sendTime = System.currentTimeMillis();
    }

    public long getElapsedTimeMillis() {
        return System.currentTimeMillis() - this.sendTime;
    }

    public Command getCommand() {
        return this.command;
    }

    public int getNbRetry() {
        return this.nbRetry;
    }

    public void incNbRetry() {
        ++this.nbRetry;
    }

    public String toString() {
        LocalDateTime ldt = Instant.ofEpochMilli(this.sendTime).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return "Command sent at " + DateTimeFormatter.ofPattern("YYYY-MM-dd HH:mm:ss").format(ldt) + " : " + this.command;
    }

    @Override
    public int compareTo(CommandWrapper o) {
        return this.command.getPriority();
    }
}

