/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.runner;

import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.MetaModelHelper;
import ch.sharedvd.tipi.engine.runner.ConnectionCap;
import ch.sharedvd.tipi.engine.utils.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectionCapManager {
    private ConnectionCap defaultCap;
    private final List<ConnectionCap> ordered = new ArrayList<ConnectionCap>();
    private final Map<String, ConnectionCap> caps = new HashMap<String, ConnectionCap>();
    private final Map<ConnectionCap, Integer> nbCurrentConcurrents = new HashMap<ConnectionCap, Integer>();
    private final Map<Long, ActivityMetaModel> currentActivities = new HashMap<Long, ActivityMetaModel>();

    public void register(ConnectionCap cap) {
        Assert.notNull((Object)cap);
        Assert.notNull((Object)cap.getName());
        Assert.notNull((Object)cap.getDescription());
        Assert.isTrue((cap.getNbMaxConcurrent() > 0 ? 1 : 0) != 0);
        this.caps.put(cap.getName(), cap);
        this.ordered.add(cap);
        if (cap.isDefault()) {
            Assert.isNull((Object)this.defaultCap);
            this.defaultCap = cap;
        }
        this.nbCurrentConcurrents.put(cap, 0);
    }

    public int getNbMaxConcurrent(String aName) {
        return this.caps.get(aName).getNbMaxConcurrent();
    }

    public void setNbMaxConcurrent(String aName, int aNbMaxConcurrent) {
        this.caps.get(aName).setNbMaxConcurrent(aNbMaxConcurrent);
    }

    public int getNbCurrentConcurrent(String aName) {
        ConnectionCap cap = this.getCap(aName);
        Assert.notNull((Object)cap);
        return this.nbCurrentConcurrents.get(cap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConnections(ActivityMetaModel aActivity) {
        boolean hasRoom = true;
        Map<ConnectionCap, Integer> map = this.nbCurrentConcurrents;
        synchronized (map) {
            boolean bl = hasRoom = this.getFreeConnections(this.defaultCap) > 0;
            if (hasRoom) {
                String name;
                ConnectionCap ct;
                Iterator<String> iterator = aActivity.getUsedConnections().iterator();
                while (iterator.hasNext() && (hasRoom = this.getFreeConnections(ct = this.getCap(name = iterator.next())) > 0)) {
                }
            }
        }
        return hasRoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableConnections(ActivityMetaModel aActivity) {
        int availableConnections = 0;
        Map<ConnectionCap, Integer> map = this.nbCurrentConcurrents;
        synchronized (map) {
            availableConnections = this.getFreeConnections(this.defaultCap);
            for (String name : aActivity.getUsedConnections()) {
                ConnectionCap ct = this.getCap(name);
                int freeConnection = this.getFreeConnections(ct);
                if (freeConnection >= availableConnections) continue;
                availableConnections = freeConnection;
            }
        }
        return availableConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String aActivityName, Long aActivityId) {
        Assert.notNull((Object)aActivityName);
        Assert.notNull((Object)aActivityId);
        ActivityMetaModel amm = MetaModelHelper.createActivityMetaModel(aActivityName);
        Assert.notNull((Object)amm);
        this.currentActivities.put(aActivityId, amm);
        Map<ConnectionCap, Integer> map = this.nbCurrentConcurrents;
        synchronized (map) {
            this.incCurrent(this.defaultCap);
            for (String name : amm.getUsedConnections()) {
                ConnectionCap ct = this.getCap(name);
                this.incCurrent(ct);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Long aActivityId) {
        Assert.notNull((Object)aActivityId);
        ActivityMetaModel amm = this.currentActivities.remove(aActivityId);
        if (null != amm) {
            Map<ConnectionCap, Integer> map = this.nbCurrentConcurrents;
            synchronized (map) {
                for (String name : amm.getUsedConnections()) {
                    ConnectionCap ct = this.getCap(name);
                    this.decCurrent(ct);
                }
                this.decCurrent(this.defaultCap);
            }
        }
    }

    public ConnectionCap getCap(String name) {
        ConnectionCap cap = this.caps.get(name);
        Assert.notNull((Object)cap, (String)("Cap not found: " + name));
        return cap;
    }

    private int getFreeConnections(ConnectionCap cap) {
        Assert.notNull((Object)cap);
        Assert.isTrue((this.nbCurrentConcurrents.get(cap) >= 0 ? 1 : 0) != 0, (String)("Cap: " + cap.getName()));
        return cap.getNbMaxConcurrent() - this.nbCurrentConcurrents.get(cap);
    }

    private void incCurrent(ConnectionCap cap) {
        Assert.notNull((Object)cap);
        this.nbCurrentConcurrents.put(cap, this.nbCurrentConcurrents.get(cap) + 1);
        Assert.isTrue((this.nbCurrentConcurrents.get(cap) >= 0 ? 1 : 0) != 0, (String)("Cap: " + cap.getName()));
    }

    private void decCurrent(ConnectionCap cap) {
        Assert.notNull((Object)cap);
        this.nbCurrentConcurrents.put(cap, this.nbCurrentConcurrents.get(cap) - 1);
        Assert.isTrue((this.nbCurrentConcurrents.get(cap) >= 0 ? 1 : 0) != 0, (String)("Cap: " + cap.getName()));
    }

    public List<ConnectionCap> getCaps() {
        return this.ordered;
    }
}

