/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.svc;

import ch.sharedvd.tipi.engine.action.ActivityFacade;
import ch.sharedvd.tipi.engine.client.VariableMap;
import ch.sharedvd.tipi.engine.meta.ActivityMetaModel;
import ch.sharedvd.tipi.engine.meta.MetaModelHelper;
import ch.sharedvd.tipi.engine.meta.SubProcessMetaModel;
import ch.sharedvd.tipi.engine.meta.VariableDescription;
import ch.sharedvd.tipi.engine.model.DbActivity;
import ch.sharedvd.tipi.engine.model.DbBooleanVariable;
import ch.sharedvd.tipi.engine.model.DbInputStreamVariable;
import ch.sharedvd.tipi.engine.model.DbIntegerVariable;
import ch.sharedvd.tipi.engine.model.DbLongVariable;
import ch.sharedvd.tipi.engine.model.DbSerializableVariable;
import ch.sharedvd.tipi.engine.model.DbStringVariable;
import ch.sharedvd.tipi.engine.model.DbSubProcess;
import ch.sharedvd.tipi.engine.model.DbTimestampVariable;
import ch.sharedvd.tipi.engine.model.DbTopProcess;
import ch.sharedvd.tipi.engine.model.DbVariable;
import ch.sharedvd.tipi.engine.repository.ActivityRepository;
import ch.sharedvd.tipi.engine.svc.UndefinedVariableException;
import ch.sharedvd.tipi.engine.svc.WrongTypeVariableException;
import ch.sharedvd.tipi.engine.utils.Assert;
import ch.sharedvd.tipi.engine.utils.BlobFactory;
import ch.sharedvd.tipi.engine.utils.InputStreamHolder;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityPersisterService {
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private EntityManager em;

    private DbActivity createModelFromMeta(ActivityMetaModel meta, boolean isProcess, VariableMap vars) {
        Assert.notNull((Object)meta);
        DbActivity a = null;
        a = isProcess ? new DbTopProcess() : (meta instanceof SubProcessMetaModel ? new DbSubProcess() : new DbActivity());
        a.setFqn(meta.getFQN());
        a.setProcessName(meta.getFQN());
        this.putVariables(a, meta, vars);
        return a;
    }

    public DbActivity persistModelFromMeta(ActivityMetaModel meta, boolean isProcess, VariableMap vars) {
        DbActivity model = this.createModelFromMeta(meta, isProcess, vars);
        return (DbActivity)this.activityRepository.save(model);
    }

    public long addChildActivity(ActivityMetaModel meta, DbSubProcess parent, Long previousId, VariableMap vars, String correlationId) {
        Assert.notNull((Object)parent);
        Assert.notNull((Object)meta);
        DbActivity act = this.persistModelFromMeta(meta, false, vars);
        act.setParent(parent);
        act.setProcess(parent.getProcessOrThis());
        act.setCorrelationId(correlationId);
        Assert.notNull((Object)act.getProcess());
        if (previousId != null) {
            DbActivity previous = (DbActivity)this.activityRepository.findOne(previousId);
            Assert.notNull((Object)previous);
            Assert.isEqual(parent, previous.getParent());
            act.setPrevious(previous);
        }
        return act.getId();
    }

    public List<ActivityFacade> getChildren(long parentId) {
        ArrayList<ActivityFacade> activities = new ArrayList<ActivityFacade>();
        List<DbActivity> actis = this.activityRepository.findByParentId(parentId);
        for (DbActivity a : actis) {
            activities.add(new ActivityFacade(a.getId(), this, this.activityRepository));
        }
        return activities;
    }

    public DbActivity getModel(long id) {
        return (DbActivity)this.activityRepository.findOne(Long.valueOf(id));
    }

    public void putVariables(DbActivity aDbActivity, ActivityMetaModel meta, VariableMap vars) {
        if (vars != null) {
            for (String key : vars.keySet()) {
                Serializable value = vars.get(key);
                this.putVariable(aDbActivity, meta, key, value);
            }
        }
    }

    public void putVariable(DbActivity aDbActivity, String key, Serializable value) {
        ActivityMetaModel meta = MetaModelHelper.createActivityMetaModel(aDbActivity.getFqn());
        this.putVariable(aDbActivity, meta, key, value);
    }

    public void putVariable(DbActivity aDbActivity, ActivityMetaModel meta, String key, Serializable value) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)value, (String)("Missing value for key=" + key));
        VariableDescription vd = meta.getVariable(key);
        if (vd != null) {
            if (!vd.getVariableType().isCompatible(value)) {
                throw new WrongTypeVariableException(key, vd.getVariableType().getClazz(), value.getClass());
            }
        } else {
            throw new UndefinedVariableException(key);
        }
        this.reallyPutVariable(aDbActivity, key, value);
    }

    private void reallyPutVariable(DbActivity aDbActivity, String key, Serializable value) {
        DbVariable variable;
        Assert.notNull((Object)key);
        Assert.notNull((Object)value, (String)("Missing value for key=" + key));
        if (value instanceof String) {
            variable = new DbStringVariable(key, (String)((Object)value));
        } else if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            String str = DateTimeFormatter.ofPattern("YYYYMMdd").format(date);
            Integer i = Integer.parseInt(str);
            variable = new DbIntegerVariable(key, i);
        } else {
            variable = value instanceof Integer ? new DbIntegerVariable(key, (Integer)value) : (value instanceof Long ? new DbLongVariable(key, (Long)value) : (value instanceof Boolean ? new DbBooleanVariable(key, (Boolean)value) : (value instanceof Timestamp ? new DbTimestampVariable(key, (Timestamp)value) : (value instanceof InputStreamHolder ? new DbInputStreamVariable(key, (InputStreamHolder)value, new BlobFactory((Session)this.em.getDelegate())) : new DbSerializableVariable(key, value, new BlobFactory((Session)this.em.getDelegate()))))));
        }
        variable.setOwner(aDbActivity);
        aDbActivity.putVariable(variable);
    }
}

