/*
 * Decompiled with CFR 0.152.
 */
package ch.sharedvd.tipi.engine.utils;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

public class BeanAutowirer
implements ApplicationContextAware {
    private AbstractApplicationContext applicationContext;

    public BeanAutowirer() {
    }

    public BeanAutowirer(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (AbstractApplicationContext)applicationContext;
    }

    public void autowire(Object act) {
        AutowiredAnnotationBeanPostProcessor proc = new AutowiredAnnotationBeanPostProcessor();
        proc.setBeanFactory((BeanFactory)this.applicationContext.getBeanFactory());
        proc.processInjection(act);
        if (act instanceof ApplicationContextAware) {
            ((ApplicationContextAware)act).setApplicationContext((ApplicationContext)this.applicationContext);
        }
        if (act instanceof InitializingBean) {
            try {
                ((InitializingBean)act).afterPropertiesSet();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BeanCreationException("Impossible d'autowirer " + act.getClass(), (Throwable)e);
            }
        }
    }
}

