/*
 * Decompiled with CFR 0.152.
 */
package ch.simas.camel.webdav;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;

public class WebdavProducer
extends DefaultProducer {
    private final String host;
    private final String fileName;
    private final String charset;
    private final Sardine sardine;

    public WebdavProducer(Endpoint endpoint, String host, String username, String password, String fileName, String charset) {
        super(endpoint);
        this.host = host;
        this.sardine = SardineFactory.begin((String)username, (String)password);
        this.fileName = fileName;
        this.charset = charset;
    }

    public void process(Exchange exchng) throws Exception {
        String csv = (String)exchng.getIn().getBody();
        byte[] bytes = csv.getBytes(this.charset);
        String path = "https://" + this.host;
        this.sardine.list(path);
        this.sardine.put(path + "/" + this.fileName, bytes);
    }
}

