/*
 * Decompiled with CFR 0.152.
 */
package spark.staticfiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.resource.AbstractFileResolvingResource;
import spark.resource.AbstractResourceHandler;
import spark.resource.ClassPathResource;
import spark.resource.ClassPathResourceHandler;
import spark.resource.ExternalResource;
import spark.resource.ExternalResourceHandler;
import spark.resource.JarResourceHandler;
import spark.utils.Assert;
import spark.utils.GzipUtils;
import spark.utils.IOUtils;

public class StaticFilesConfiguration {
    private final Logger LOG = LoggerFactory.getLogger(StaticFilesConfiguration.class);
    private List<AbstractResourceHandler> staticResourceHandlers = null;
    private List<JarResourceHandler> jarResourceHandlers = null;
    private boolean staticResourcesSet = false;
    private boolean externalStaticResourcesSet = false;
    public static StaticFilesConfiguration servletInstance = new StaticFilesConfiguration();
    private Map<String, String> customHeaders = new HashMap<String, String>();

    public boolean consume(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.consumeWithFileResourceHandlers(httpRequest, httpResponse)) {
            return true;
        }
        return this.consumeWithJarResourceHandler(httpRequest, httpResponse);
    }

    private boolean consumeWithFileResourceHandlers(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.staticResourceHandlers != null) {
            for (AbstractResourceHandler staticResourceHandler : this.staticResourceHandlers) {
                AbstractFileResolvingResource resource = staticResourceHandler.getResource(httpRequest);
                if (resource == null || !resource.isReadable()) continue;
                OutputStream wrappedOutputStream = GzipUtils.checkAndWrap(httpRequest, httpResponse, false);
                this.customHeaders.forEach(httpResponse::setHeader);
                IOUtils.copy(resource.getInputStream(), wrappedOutputStream);
                wrappedOutputStream.flush();
                wrappedOutputStream.close();
                return true;
            }
        }
        return false;
    }

    private boolean consumeWithJarResourceHandler(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.jarResourceHandlers != null) {
            for (JarResourceHandler jarResourceHandler : this.jarResourceHandlers) {
                InputStream stream = jarResourceHandler.getResource(httpRequest);
                if (stream == null) continue;
                OutputStream wrappedOutputStream = GzipUtils.checkAndWrap(httpRequest, httpResponse, false);
                this.customHeaders.forEach(httpResponse::setHeader);
                IOUtils.copy(stream, wrappedOutputStream);
                wrappedOutputStream.flush();
                wrappedOutputStream.close();
                return true;
            }
        }
        return false;
    }

    public void clear() {
        if (this.staticResourceHandlers != null) {
            this.staticResourceHandlers.clear();
            this.staticResourceHandlers = null;
        }
        if (this.jarResourceHandlers != null) {
            this.jarResourceHandlers.clear();
            this.jarResourceHandlers = null;
        }
        this.staticResourcesSet = false;
        this.externalStaticResourcesSet = false;
    }

    public synchronized void configure(String folder) {
        Assert.notNull(folder, "'folder' must not be null");
        if (!this.staticResourcesSet) {
            try {
                ClassPathResource resource = new ClassPathResource(folder);
                if (this.configureJarCase(folder, resource)) {
                    return;
                }
                if (!resource.getFile().isDirectory()) {
                    this.LOG.error("Static resource location must be a folder");
                    return;
                }
                if (this.staticResourceHandlers == null) {
                    this.staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
                }
                this.staticResourceHandlers.add(new ClassPathResourceHandler(folder, "index.html"));
                this.LOG.info("StaticResourceHandler configured with folder = " + folder);
            }
            catch (IOException e) {
                this.LOG.error("Error when creating StaticResourceHandler", e);
            }
            this.staticResourcesSet = true;
        }
    }

    private boolean configureJarCase(String folder, ClassPathResource resource) throws IOException {
        if (resource.getURL().getProtocol().equals("jar")) {
            InputStream stream = StaticFilesConfiguration.class.getResourceAsStream(folder);
            if (stream != null) {
                if (this.jarResourceHandlers == null) {
                    this.jarResourceHandlers = new ArrayList<JarResourceHandler>();
                }
                this.jarResourceHandlers.add(new JarResourceHandler(folder, "index.html"));
                this.staticResourcesSet = true;
                return true;
            }
            this.LOG.error("Static file configuration failed.");
        }
        return false;
    }

    public synchronized void configureExternal(String folder) {
        Assert.notNull(folder, "'folder' must not be null");
        if (!this.externalStaticResourcesSet) {
            try {
                ExternalResource resource = new ExternalResource(folder);
                if (!resource.getFile().isDirectory()) {
                    this.LOG.error("External Static resource location must be a folder");
                    return;
                }
                if (this.staticResourceHandlers == null) {
                    this.staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
                }
                this.staticResourceHandlers.add(new ExternalResourceHandler(folder, "index.html"));
                this.LOG.info("External StaticResourceHandler configured with folder = " + folder);
            }
            catch (IOException e) {
                this.LOG.error("Error when creating external StaticResourceHandler", e);
            }
            this.externalStaticResourcesSet = true;
        }
    }

    public static StaticFilesConfiguration create() {
        return new StaticFilesConfiguration();
    }

    public void setExpireTimeSeconds(long expireTimeSeconds) {
        this.customHeaders.put("Cache-Control", "private, max-age=" + expireTimeSeconds);
        this.customHeaders.put("Expires", new Date(System.currentTimeMillis() + expireTimeSeconds * 1000L).toString());
    }

    public void putCustomHeaders(Map<String, String> headers) {
        this.customHeaders.putAll(headers);
    }

    public void putCustomHeader(String key, String value) {
        this.customHeaders.put(key, value);
    }
}

