/*
 * Decompiled with CFR 0.152.
 */
package ch.simschla.minify.ant;

import ch.simschla.minify.adapter.Minifier;
import ch.simschla.minify.streams.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class MinifyAntTask
extends Task {
    private final DelegatingCopy delegate;
    private final FileUtils fileUtils;
    private String header = "";
    private ConversionType type = ConversionType.auto;

    public MinifyAntTask() {
        this.delegate = this.createNewConfiguredDelegate();
        this.fileUtils = FileUtils.newFileUtils();
        this.setupDefaultValues();
    }

    private DelegatingCopy createNewConfiguredDelegate() {
        DelegatingCopy copy = new DelegatingCopy();
        copy.setFiltering(false);
        return copy;
    }

    private void setupDefaultValues() {
        this.setEncoding("UTF-8");
        this.setFailOnError(false);
        this.setFlatten(false);
        this.setOverwrite(false);
    }

    private void minify(String fromFile, List<String> toFiles) {
        Minifier minifierForFile = this.determineMinifier(fromFile);
        if (minifierForFile == null) {
            this.log("Cannot minify file " + fromFile + " - unsupported file type!", 4);
            return;
        }
        for (String toFile : toFiles) {
            this.minifyOneFile(minifierForFile, new File(fromFile), new File(toFile));
        }
    }

    private Minifier determineMinifier(String fromFile) {
        Minifier minifierForFile = null;
        minifierForFile = this.type() == ConversionType.auto ? Minifier.forFileName(fromFile) : Minifier.forFileName("filename." + this.type().name());
        return minifierForFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minifyOneFile(Minifier minifier, File fromFile, File toFile) {
        if (this.shouldSkipMinification(fromFile, toFile)) {
            return;
        }
        this.createDirectoriesIfNeeded(toFile);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(fromFile);
            out = new FileOutputStream(toFile);
            minifier.minify(in, out, this.charset(), this.header());
        }
        catch (FileNotFoundException e) {
            try {
                this.log("Cannot minify file " + fromFile + " to " + toFile + " due to FileNotFoundException: " + e.getMessage(), 1);
            }
            catch (Throwable throwable) {
                Streams.close(in);
                Streams.close(out);
                throw throwable;
            }
            Streams.close(in);
            Streams.close(out);
        }
        Streams.close(in);
        Streams.close(out);
    }

    private void createDirectoriesIfNeeded(File toFile) {
        File parentFile = toFile.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    private boolean shouldSkipMinification(File fromFile, File toFile) {
        boolean shouldSkip = false;
        if (toFile.exists() && !this.overwrite()) {
            this.log("Skipping minification of file " + fromFile + " to " + toFile + ". " + toFile + " already exists and should not be overwritten.", 4);
            shouldSkip = true;
        }
        if (toFile.equals(fromFile)) {
            this.log("Skipping minifying file " + fromFile + " onto itself on " + toFile + ".", 3);
            shouldSkip = true;
        }
        return shouldSkip;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    private String header() {
        return this.header;
    }

    private Charset charset() {
        return Charset.forName(this.delegate.getEncoding());
    }

    public void setType(ConversionType type) {
        this.type = type;
    }

    private ConversionType type() {
        return this.type;
    }

    public void execute() throws BuildException {
        this.delegate.execute();
    }

    public void setFile(File file) {
        this.delegate.setFile(file);
    }

    public void setTofile(File destFile) {
        this.delegate.setTofile(destFile);
    }

    public void setTodir(File destDir) {
        this.delegate.setTodir(destDir);
    }

    public void setOverwrite(boolean overwrite) {
        this.delegate.setOverwrite(overwrite);
    }

    private boolean overwrite() {
        return this.delegate.overwrite();
    }

    public void setFlatten(boolean flatten) {
        this.delegate.setFlatten(flatten);
    }

    public void setFailOnError(boolean failonerror) {
        this.delegate.setFailOnError(failonerror);
    }

    public void setEncoding(String encoding) {
        this.delegate.setEncoding(encoding);
        this.delegate.setOutputEncoding(encoding);
    }

    public void addFileset(FileSet set) {
        this.delegate.addFileset(set);
    }

    public void add(FileNameMapper fileNameMapper) {
        this.delegate.add(fileNameMapper);
    }

    public Mapper createMapper() throws BuildException {
        return this.delegate.createMapper();
    }

    public void add(ResourceCollection res) {
        this.delegate.add(res);
    }

    public void setEnableMultipleMappings(boolean enableMultipleMappings) {
        this.delegate.setEnableMultipleMappings(enableMultipleMappings);
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.delegate.setProject(project);
    }

    public void setOwningTarget(Target target) {
        super.setOwningTarget(target);
        this.delegate.setOwningTarget(target);
    }

    public void setTaskName(String name) {
        super.setTaskName(name);
        this.delegate.setTaskName(name);
    }

    public void setTaskType(String type) {
        super.setTaskType(type);
        this.delegate.setTaskType(type);
    }

    public void setRuntimeConfigurableWrapper(RuntimeConfigurable wrapper) {
        super.setRuntimeConfigurableWrapper(wrapper);
        this.delegate.setRuntimeConfigurableWrapper(wrapper);
    }

    public void setLocation(Location location) {
        super.setLocation(location);
        this.delegate.setLocation(location);
    }

    public void setDescription(String desc) {
        super.setDescription(desc);
        this.delegate.setDescription(desc);
    }

    private final class DelegatingCopy
    extends Copy {
        private DelegatingCopy() {
        }

        protected void doFileOperations() {
            for (Map.Entry<String, String[]> fileCopyMapEntry : this.fileCopyMap().entrySet()) {
                MinifyAntTask.this.minify(fileCopyMapEntry.getKey(), Arrays.asList((Object[])fileCopyMapEntry.getValue()));
            }
        }

        private Map<String, String[]> fileCopyMap() {
            Hashtable fileCopyMap = this.fileCopyMap;
            return fileCopyMap;
        }

        private boolean overwrite() {
            return this.forceOverwrite;
        }
    }

    public static enum ConversionType {
        auto,
        css,
        js;

    }
}

