/*
 * Decompiled with CFR 0.152.
 */
package ch.simschla.minify.cli.parsing;

import ch.simschla.minify.precondition.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class CliArguments {
    public static final String OPTION_PREFIX = "-";
    private final List<String> arguments = new ArrayList<String>(2);
    private final Map<String, String> options = new LinkedHashMap<String, String>(3);

    public CliArguments(String[] cliArgs) {
        this(Arrays.asList(cliArgs));
    }

    public CliArguments(List<String> cliArgs) {
        this.parseArgs(this.argListAsStack(cliArgs));
    }

    private Stack<String> argListAsStack(List<String> cliArgs) {
        Stack<String> argStack = new Stack<String>();
        List<String> argsReversed = this.reverse(cliArgs);
        for (String arg : argsReversed) {
            argStack.push(arg);
        }
        return argStack;
    }

    private List<String> reverse(List<String> cliArgs) {
        ArrayList<String> argsReversed = new ArrayList<String>(cliArgs);
        Collections.reverse(argsReversed);
        return argsReversed;
    }

    private void parseArgs(Stack<String> cliArgs) {
        while (!cliArgs.isEmpty()) {
            String argument = cliArgs.pop();
            if (this.isOption(argument)) {
                String optionName = this.getOptionName(argument);
                String optionValue = this.getOptionValue(cliArgs);
                this.options.put(optionName, optionValue);
                continue;
            }
            this.arguments.add(argument);
        }
    }

    private String getOptionValue(Stack<String> cliArgs) {
        if (cliArgs.isEmpty()) {
            return null;
        }
        return cliArgs.pop();
    }

    private boolean isOption(String argument) {
        return Preconditions.checkNotNull(argument).startsWith(OPTION_PREFIX);
    }

    private String getOptionName(String argument) {
        return Preconditions.checkNotNull(argument).substring(OPTION_PREFIX.length());
    }

    public String option(String optionName) {
        Preconditions.checkNotNull(optionName);
        return this.options.get(optionName);
    }

    public boolean hasOption(String optionName) {
        Preconditions.checkNotNull(optionName);
        return this.options.containsKey(optionName);
    }

    public int optionCount() {
        return this.options.size();
    }

    public int argumentCount() {
        return this.arguments.size();
    }

    public String argument(int index) {
        Preconditions.checkLessThan(index, this.argumentCount());
        return this.arguments.get(index);
    }
}

