/*
 * Decompiled with CFR 0.152.
 */
package ch.simschla.minify.css;

import ch.simschla.minify.header.CustomHeaderWriter;
import ch.simschla.minify.precondition.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class CssMin {
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final CustomHeaderWriter headerWriter;
    private final String customHeader;
    private int theLookahead = -1;
    private State tmp_state;
    private State state = State.STATE_FREE;
    private State last_state = State.STATE_FREE;
    private boolean in_paren = false;

    private CssMin(Builder builder) {
        this.inputStream = builder.inputStream();
        this.outputStream = builder.outputStream();
        this.customHeader = builder.customHeader();
        this.headerWriter = CustomHeaderWriter.builder().charset(builder.charset()).outputStream(builder.outputStream()).commentLinePrefix("/* ").commentLinePostfix(" */").build();
    }

    public void minify() {
        try {
            this.writeCustomHeader();
            this.cssmin();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.outputStream.flush();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeCustomHeader() {
        this.headerWriter.writeHeader(this.customHeader);
    }

    private void cssmin() throws IOException {
        int c;
        while ((c = this.get()) != -1) {
            if ((c = this.machine(c)) == 0) continue;
            this.outputStream.write(c);
        }
        return;
    }

    private int get() throws IOException {
        int c = this.theLookahead;
        this.theLookahead = -1;
        if (c == -1) {
            c = this.inputStream.read();
        }
        if (c >= 32 || c == 10 || c == -1) {
            return c;
        }
        if (c == 13) {
            return 10;
        }
        return 32;
    }

    private int peek() throws IOException {
        this.theLookahead = this.get();
        return this.theLookahead;
    }

    /*
     * Unable to fully structure code
     */
    private int machine(int c) throws IOException {
        if (this.state != State.STATE_COMMENT && c == 47 && this.peek() == 42) {
            this.tmp_state = this.state;
            this.state = State.STATE_COMMENT;
        }
        switch (1.$SwitchMap$ch$simschla$minify$css$CssMin$State[this.state.ordinal()]) {
            case 1: {
                if (c != 32 || c != 10) ** GOTO lbl9
                c = 0;
                ** GOTO lbl14
lbl9:
                // 1 sources

                if (c == 64) {
                    this.state = State.STATE_ATRULE;
                    break;
                }
                if (c > 0) {
                    this.state = State.STATE_SELECTOR;
                }
            }
lbl14:
            // 5 sources

            case 2: {
                if (c == 123) {
                    this.state = State.STATE_BLOCK;
                    break;
                }
                if (c == 10) {
                    c = 0;
                    break;
                }
                if (c == 64) {
                    this.state = State.STATE_ATRULE;
                    break;
                }
                if (c != 32 || this.peek() != 123) break;
                c = 0;
                break;
            }
            case 3: {
                if (c == 10 || c == 59) {
                    c = 59;
                    this.state = State.STATE_FREE;
                    break;
                }
                if (c != 123) break;
                this.state = State.STATE_BLOCK;
                break;
            }
            case 4: {
                if (c == 32 || c == 10) {
                    c = 0;
                    break;
                }
                if (c == 125) {
                    this.state = State.STATE_FREE;
                    break;
                }
                this.state = State.STATE_DECLARATION;
            }
            case 5: {
                if (c == 40) {
                    this.in_paren = true;
                }
                if (!this.in_paren) {
                    if (c == 59) {
                        this.state = State.STATE_BLOCK;
                        if (this.peek() != 125) break;
                        c = 0;
                        break;
                    }
                    if (c == 125) {
                        this.state = State.STATE_FREE;
                        break;
                    }
                    if (c == 10) {
                        c = 0;
                        break;
                    }
                    if (c != 32 || this.peek() != c) break;
                    c = 0;
                    break;
                }
                if (c != 41) break;
                this.in_paren = false;
                break;
            }
            case 6: {
                if (c == 42 && this.peek() == 47) {
                    this.theLookahead = -1;
                    this.state = this.tmp_state;
                }
                c = 0;
            }
        }
        return c;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private InputStream inputStream = System.in;
        private OutputStream outputStream = System.out;
        private String customHeader = "";
        private Charset charset = Charset.forName("UTF-8");

        public InputStream inputStream() {
            return this.inputStream;
        }

        public OutputStream outputStream() {
            return this.outputStream;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = Preconditions.checkNotNull(inputStream);
            return this;
        }

        public Builder outputStream(OutputStream outputStream) {
            this.outputStream = Preconditions.checkNotNull(outputStream);
            return this;
        }

        public String customHeader() {
            return this.customHeader;
        }

        public Builder customHeader(String customHeader) {
            this.customHeader = Preconditions.checkNotNull(customHeader);
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        public Builder charset(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
            return this;
        }

        public CssMin build() {
            return new CssMin(this);
        }
    }

    private static enum State {
        STATE_FREE,
        STATE_ATRULE,
        STATE_SELECTOR,
        STATE_BLOCK,
        STATE_DECLARATION,
        STATE_COMMENT;

    }
}

