/*
 * Decompiled with CFR 0.152.
 */
package ch.simschla.minify.streams;

import ch.simschla.minify.precondition.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Streams {
    private Streams() {
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream fileInputStream(File fileIn) throws RuntimeException {
        Preconditions.checkNotNull(fileIn);
        if (!fileIn.exists()) {
            throw new RuntimeException(new IOException("File " + fileIn + " does not exist."));
        }
        if (!fileIn.canRead()) {
            throw new RuntimeException(new IOException("File " + fileIn + " cannot be read."));
        }
        try {
            return new FileInputStream(fileIn);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static OutputStream fileOutputStream(File fileOut) {
        Preconditions.checkNotNull(fileOut);
        if (fileOut.exists() && !fileOut.canWrite()) {
            throw new RuntimeException(new IOException("Cannot write to file " + fileOut + "."));
        }
        try {
            return new FileOutputStream(fileOut);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

