/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.rres;

import ch.software_atelier.simpleflex.rest.DefaultRestResource;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.ExceptionHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.swagger.BodyParameter;
import ch.software_atelier.simpleflex.rest.swagger.HeaderParameter;
import ch.software_atelier.simpleflex.rest.swagger.MethodDocumentation;
import ch.software_atelier.simpleflex.rest.swagger.ObjectSchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.Parameter;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class FlexibleTokenResource
extends DefaultRestResource {
    private final DataHandler _dh;
    private final TokenHandler _th;
    private final TokenParser _tp;

    public FlexibleTokenResource(DataHandler dh, TokenHandler th, TokenParser tp) {
        this._tp = tp;
        this._dh = dh;
        this._th = th;
    }

    public RestResponse onPOST(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            if (token == null) {
                return RestResponse.unauthorized_401();
            }
            if (this._tp.getUsername(token) == null) {
                return RestResponse.unauthorized_401();
            }
            JSONObject data = request.getJSON();
            if (!data.has("lifetime") || !data.has("claims")) {
                return RestResponse.internalServerError_500((Object)"Bad request");
            }
            int lifetime = data.getInt("lifetime");
            JSONObject jclaims = data.getJSONObject("claims");
            HashMap<String, Object> claims = new HashMap<String, Object>();
            for (String key : jclaims.keySet()) {
                claims.put(key, jclaims.get(key));
            }
            String flexible_token = this._th.createToken(claims, lifetime);
            JSONObject result = new JSONObject();
            result.put("access_token", (Object)flexible_token);
            result.put("lifetime", lifetime);
            return RestResponse.json_201_created((JSONObject)result);
        }
        catch (TokenHandlerException | JSONException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docPOST(MethodDocumentation request) {
        request.addTag("Authorisazion");
        request.setTitle("Create Flexible Token");
        request.setDescription("Creates a flexible token that can be used for some actions");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new BodyParameter("body", ObjectSchemaBuilder.create((String)"The User Credentials").addSimpleProperty("lifetime", "number", "the lifetime in seconds", true).addObjectProperty("claims", ObjectSchemaBuilder.create((String)"the claims").addSimpleProperty("key", "string", "key value paires", true).toJSON(), true).toJSON()));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"the flexible token").addSimpleProperty("access_token", "string", "the new access token", true).addSimpleProperty("lifetime", "number", "the session lifetime in seconds", true).toJSON());
    }
}

