/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.rres;

import ch.software_atelier.simpleflex.rest.DefaultRestResource;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.ExceptionHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.swagger.BodyParameter;
import ch.software_atelier.simpleflex.rest.swagger.HeaderParameter;
import ch.software_atelier.simpleflex.rest.swagger.MethodDocumentation;
import ch.software_atelier.simpleflex.rest.swagger.ObjectSchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.Parameter;
import ch.software_atelier.simpleflex.rest.swagger.PathParameter;
import org.json.JSONObject;

public class GroupACLResource
extends DefaultRestResource {
    private final DataHandler _dh;
    private final TokenHandler _th;
    private final TokenParser _tp;

    public GroupACLResource(DataHandler dh, TokenHandler th, TokenParser tp) {
        this._tp = tp;
        this._dh = dh;
        this._th = th;
    }

    public RestResponse onPUT(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String userByToken = this._tp.getUsername(token);
            String groupByPath = request.getResourcePlaceholder("name");
            if (this._tp.isAdmin(token)) {
                JSONObject req = request.getJSON();
                String yaml = req.getString("yaml");
                this._dh.putGroupACL(groupByPath, yaml);
                return RestResponse.json_200((JSONObject)new JSONObject().put("ok", true));
            }
            return RestResponse.unauthorized_401();
        }
        catch (DataHandlerException | TokenHandlerException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docPUT(MethodDocumentation request) {
        request.setTitle("Put Group ACL");
        request.addTag("Authorisazion");
        request.setDescription("Saves the groups ACL if the requesting user has admin previliges.\r\n");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the groupname"));
        request.addParameter((Parameter)new BodyParameter("body", ObjectSchemaBuilder.create((String)"the Access control list as YAML").addSimpleProperty("yaml", "string", "the ACL as YAML", true).toJSON()));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"ok").addSimpleProperty("ok", "boolean", "will always be true", true).toJSON());
    }

    public RestResponse onGET(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String userByToken = this._tp.getUsername(token);
            String userByPath = request.getResourcePlaceholder("name");
            if (this._tp.isAdmin(token)) {
                JSONObject result = new JSONObject().put("yaml", (Object)this._dh.getGroupACLasYAML(userByPath));
                return RestResponse.json_200((JSONObject)result);
            }
            return RestResponse.unauthorized_401();
        }
        catch (DataHandlerException | TokenHandlerException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docGET(MethodDocumentation request) {
        request.setTitle("Get Group ACL");
        request.addTag("Authorisazion");
        request.setDescription("Returns the groups ACL if the requesting user has admin previliges.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the groupname"));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"the groups ACL as YAML").addSimpleProperty("yaml", "string", "the ACL as YAML", true).toJSON());
    }
}

