/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.rres;

import ch.software_atelier.simpleflex.rest.DefaultRestResource;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.ExceptionHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.rres.SessionResource;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.swagger.ArraySchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.BodyParameter;
import ch.software_atelier.simpleflex.rest.swagger.HeaderParameter;
import ch.software_atelier.simpleflex.rest.swagger.MethodDocumentation;
import ch.software_atelier.simpleflex.rest.swagger.ObjectSchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.Parameter;
import ch.software_atelier.simpleflex.rest.swagger.PathParameter;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class SpecificUserResource
extends DefaultRestResource {
    private final DataHandler _dh;
    private final TokenHandler _th;
    private final TokenParser _tp;

    public SpecificUserResource(DataHandler dh, TokenHandler th, TokenParser tp) {
        this._tp = tp;
        this._dh = dh;
        this._th = th;
    }

    public RestResponse onGET(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String usernameByToken = this._tp.getUsername(token);
            String usernameByPath = request.getResourcePlaceholder("name");
            if (usernameByToken.equals(usernameByPath) || this._tp.isAdmin(token)) {
                JSONObject obj = new JSONObject();
                obj.put("username", (Object)usernameByPath);
                obj.put("admin", this._dh.isAdmin(usernameByPath));
                obj.put("realms", (Object)SessionResource.realmsToArray(this._dh.getRealms(usernameByPath)));
                return RestResponse.json_200((JSONObject)obj);
            }
            return RestResponse.unauthorized_401();
        }
        catch (DataHandlerException | TokenHandlerException | NullPointerException | JSONException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docGET(MethodDocumentation request) {
        request.setTitle("User Information");
        request.addTag("Authorisazion");
        request.setDescription("Returns the User Information and the realms if the user is an admin of if he retrieves his own information.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the username"));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"The new session data").addSimpleProperty("username", "string", "the username", true).addSimpleProperty("admin", "boolean", "wether the user is admin or not", true).addObjectProperty("realms", ArraySchemaBuilder.create((String)"the realms this user has access to").setBasic("string", "a realm").toJSON(), true).toJSON());
    }

    public RestResponse onDELETE(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            if (token == null) {
                return RestResponse.unauthorized_401();
            }
            if (this._tp.isAdmin(token)) {
                String username = request.getResourcePlaceholder("name");
                if (this._tp.getUsername(token).equals(username)) {
                    return RestResponse.unauthorized_401();
                }
                this._dh.deleteUser(username);
                return RestResponse.noContent_204();
            }
            return RestResponse.unauthorized_401();
        }
        catch (TokenHandlerException the) {
            return RestResponse.unauthorized_401();
        }
        catch (NullPointerException | JSONException th) {
            return ExceptionHandler.handle(th, false);
        }
        catch (DataHandlerException th) {
            return ExceptionHandler.handle(th, false);
        }
    }

    public void docDELETE(MethodDocumentation request) {
        request.setTitle("Delete User");
        request.addTag("Authorisazion");
        request.setDescription("Deletes a user if the requestiung user is an admin and if he does not try to delete his own account.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the username"));
        request.addResponse("204", "No Content", new JSONObject());
        request.addResponse("401", "Unauthorized", new JSONObject());
    }

    public RestResponse onPUT(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String userByToken = this._tp.getUsername(token);
            String user = request.getResourcePlaceholder("name");
            JSONObject obj = request.getJSON();
            boolean changePass = obj.has("old_pass") && obj.has("pass");
            boolean changeRealms = obj.has("realms");
            boolean changeAdmin = obj.has("admin");
            if (!user.equals(userByToken) && !this._tp.isAdmin(token)) {
                return RestResponse.unauthorized_401();
            }
            if (!this._tp.isAdmin(token) & (changeRealms || changeAdmin)) {
                return RestResponse.unauthorized_401();
            }
            if (changePass) {
                String old_pass = obj.getString("old_pass");
                String pass = obj.getString("pass");
                boolean isAdmin = this._dh.isAdmin(user);
                try {
                    this._dh.verifyUser(user, old_pass);
                }
                catch (DataHandlerException e) {
                    return RestResponse.badRequest_400((Object)"old password is invalid");
                }
                this._dh.putUser(user, pass, isAdmin);
            }
            if (changeRealms) {
                JSONObject realms = obj.getJSONObject("realms");
                HashMap<String, String> realmsH = new HashMap<String, String>();
                for (String key : realms.keySet()) {
                    realmsH.put(key, realms.optString(key, ""));
                }
                this._dh.putRealms(user, realmsH);
            }
            if (changeAdmin) {
                boolean admin = obj.optBoolean("admin");
                this._dh.putAdmin(user, admin);
            }
            JSONObject response = new JSONObject();
            response.put("msg", (Object)"ok");
            return RestResponse.json_200((JSONObject)response);
        }
        catch (DataHandlerException | TokenHandlerException | JSONException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docPUT(MethodDocumentation request) {
        request.setTitle("Change password");
        request.addTag("Authorisazion");
        request.setDescription("Change the users password");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the username"));
        request.addParameter((Parameter)new BodyParameter("body", ObjectSchemaBuilder.create((String)"The Change password data").addSimpleProperty("user", "string", "the username", false).addSimpleProperty("old_pass", "string", "the previews password", false).addSimpleProperty("pass", "string", "the new password", false).addObjectProperty("realms", ObjectSchemaBuilder.create((String)"The realms. key: realmname, value: realmdescription").toJSON(), false).addSimpleProperty("admin", "boolean", "change this users admin previgiges", false).toJSON()));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"update a user").addSimpleProperty("msg", "string", "the password changed message", true).toJSON());
    }
}

