/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.rres;

import ch.software_atelier.simpleflex.rest.DefaultRestResource;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.ExceptionHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.auth.utils.JSONHelper;
import ch.software_atelier.simpleflex.rest.swagger.ArraySchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.BodyParameter;
import ch.software_atelier.simpleflex.rest.swagger.HeaderParameter;
import ch.software_atelier.simpleflex.rest.swagger.MethodDocumentation;
import ch.software_atelier.simpleflex.rest.swagger.ObjectSchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.Parameter;
import ch.software_atelier.simpleflex.rest.swagger.PathParameter;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserGroupsResource
extends DefaultRestResource {
    private final TokenHandler _th;
    private final DataHandler _dh;
    private final TokenParser _tp;

    public UserGroupsResource(DataHandler dh, TokenHandler th, TokenParser tp) {
        this._dh = dh;
        this._th = th;
        this._tp = tp;
    }

    public RestResponse onPUT(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String userByToken = this._tp.getUsername(token);
            String userByPath = request.getResourcePlaceholder("name");
            if (this._tp.isAdmin(token)) {
                JSONArray groups = request.getJSONArray();
                this._dh.setUserGroups(userByPath, JSONHelper.toStringList(groups));
                return RestResponse.json_200((JSONObject)new JSONObject().put("ok", true));
            }
            return RestResponse.unauthorized_401();
        }
        catch (DataHandlerException | TokenHandlerException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docPUT(MethodDocumentation request) {
        request.setTitle("Set User Groups");
        request.addTag("Authorisazion");
        request.setDescription("Sets the users groups if the requesting user has admin previliges.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the username"));
        request.addParameter((Parameter)new BodyParameter("body", ArraySchemaBuilder.create((String)"the groups").setBasic("string", "group names").toJSON()));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"the status object").addSimpleProperty("ok", "boolean", "always true", true).toJSON());
    }

    public RestResponse onGET(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String userByToken = this._tp.getUsername(token);
            String userByPath = request.getResourcePlaceholder("name");
            if (this._tp.isAdmin(token)) {
                JSONArray result = JSONHelper.stringList2JSONArr(this._dh.getUserGroups(userByPath));
                return RestResponse.json_200((JSONArray)result);
            }
            return RestResponse.unauthorized_401();
        }
        catch (DataHandlerException | TokenHandlerException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docGET(MethodDocumentation request) {
        request.setTitle("Get User Groups");
        request.addTag("Authorisazion");
        request.setDescription("Returns the users groups if the requesting user has admin previliges.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the username"));
        request.addResponse("200", "OK", ArraySchemaBuilder.create((String)"the users groups").setBasic("string", "group names").toJSON());
    }
}

