/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.token;

import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.auth.utils.JSONHelper;
import com.google.gson.Gson;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class TokenHandler {
    private final String _secret;
    private final DataHandler _dataHandler;
    private final int _maxSessionLength;
    private final TokenParser _parser;

    public TokenHandler(String secret, DataHandler dh, int maxSessionLength) {
        this._secret = secret;
        this._dataHandler = dh;
        this._maxSessionLength = maxSessionLength;
        this._parser = new TokenParser(secret);
    }

    public String renew(String token) throws TokenHandlerException {
        DefaultClaims claims = this._parser.getClaims(token);
        try {
            Object realms = claims.get((Object)"realms");
            Object admin = claims.get((Object)"admin");
            Object user = claims.get((Object)"username");
            Object acl = claims.get((Object)"acl");
            String newToken = Jwts.builder().setIssuer("SimpeleflexAuth").setIssuedAt(Date.from(Instant.now())).setExpiration(Date.from(Instant.now().plus((long)this._maxSessionLength, ChronoUnit.SECONDS))).claim("admin", admin).claim("realms", realms).claim("username", user).claim("acl", acl).signWith(SignatureAlgorithm.HS256, this._secret.getBytes("UTF-8")).compact();
            return newToken;
        }
        catch (UnsupportedEncodingException uee) {
            throw new TokenHandlerException(-100);
        }
    }

    public String createToken(String user) throws TokenHandlerException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        try {
            HashMap<String, String> realmsMap = this._dataHandler.getRealms(user);
            ArrayList<String> realms = new ArrayList<String>();
            Set<String> keys = realmsMap.keySet();
            for (String string : keys) {
                realms.add(string);
            }
            claims.put("admin", this._dataHandler.isAdmin(user));
            claims.put("realms", realms);
            claims.put("username", user);
            JSONObject aclJSON = new JSONObject();
            for (String group : this._dataHandler.getUserGroups(user)) {
                JSONHelper.deepMerge(this._dataHandler.getGroupACLasJSON(group), aclJSON);
            }
            JSONHelper.deepMerge(this._dataHandler.getUserACLasJSON(user), aclJSON);
            Gson gson = new Gson();
            Map acl = (Map)gson.fromJson(aclJSON.toString(), Map.class);
            claims.put("acl", acl);
        }
        catch (DataHandlerException dhe) {
            throw new TokenHandlerException(-4);
        }
        return this.createToken(claims, this._maxSessionLength);
    }

    public String createToken(HashMap<String, Object> claims, int lifetimeInSeconds) throws TokenHandlerException {
        try {
            JwtBuilder builder = Jwts.builder();
            builder = builder.setIssuer("SimpeleflexAuth").setIssuedAt(Date.from(Instant.now())).setExpiration(Date.from(Instant.now().plus((long)lifetimeInSeconds, ChronoUnit.SECONDS)));
            if (claims != null) {
                for (String key : claims.keySet()) {
                    builder = builder.claim(key, claims.get(key));
                }
            }
            String token = builder.signWith(SignatureAlgorithm.HS256, this._secret.getBytes("UTF-8")).compact();
            System.out.println(token);
            return token;
        }
        catch (UnsupportedEncodingException uee) {
            throw new TokenHandlerException(-100);
        }
    }

    public int getSessionLength() {
        return this._maxSessionLength;
    }
}

