/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth;

import ch.software_atelier.simpleflex.SimpleFlexAccesser;
import ch.software_atelier.simpleflex.SimpleFlexBase;
import ch.software_atelier.simpleflex.rest.RestApp;
import ch.software_atelier.simpleflex.rest.RestResource;
import ch.software_atelier.simpleflex.rest.auth.data.MongoDBDataHandler;
import ch.software_atelier.simpleflex.rest.auth.rres.SessionResource;
import ch.software_atelier.simpleflex.rest.auth.rres.SpecificUserResource;
import ch.software_atelier.simpleflex.rest.auth.rres.UserResource;
import ch.software_atelier.simpleflex.rest.auth.rres.UserSettingsResource;
import ch.software_atelier.simpleflex.rest.auth.rres.WebsiteLoginResource;
import ch.software_atelier.simpleflex.rest.auth.rres.test.AuthenticationPageResource;
import ch.software_atelier.simpleflex.rest.auth.rres.test.FailedResource;
import ch.software_atelier.simpleflex.rest.auth.rres.test.SecuredResource;
import ch.software_atelier.simpleflex.rest.auth.rres.test.SuccessResource;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.auth.utils.StrHlp;
import java.util.HashMap;

public class App
extends RestApp {
    public static void main(String[] args) throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("$mongoUri", "mongodb://localhost/gpdb");
        config.put("$secret", "ThisIsMyTokenSecret!!");
        config.put("$sessionTimeout", "300");
        SimpleFlexBase.serveOnLocalhost((String)App.class.getName(), config, (int)18001);
    }

    public void start(String name, HashMap<String, Object> config, SimpleFlexAccesser sfa) {
        super.start(name, config, sfa);
        try {
            MongoDBDataHandler dh = new MongoDBDataHandler(config.get("$mongoUri").toString());
            TokenHandler th = new TokenHandler(config.get("$secret").toString(), dh, (int)StrHlp.parseLong(config.get("$sessionTimeout").toString()));
            TokenParser tp = new TokenParser(config.get("$secret").toString());
            this.addResource("/session", (RestResource)new SessionResource(dh, th, tp));
            this.addResource("/user", (RestResource)new UserResource(dh, th, tp));
            this.addResource("/user/{name}", (RestResource)new SpecificUserResource(dh, th, tp));
            this.addResource("/user/{name}/settings", (RestResource)new UserSettingsResource(dh, th, tp));
            this.addResource("/login", (RestResource)new WebsiteLoginResource(dh, th, "/success", "/failed", 3600));
            this.addResource("/auth", (RestResource)new AuthenticationPageResource());
            this.addResource("/failed", (RestResource)new FailedResource());
            this.addResource("/success", (RestResource)new SuccessResource());
            this.addResource("/secured", (RestResource)new SecuredResource(tp));
        }
        catch (Throwable uhe) {
            uhe.printStackTrace();
        }
    }
}

