/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.rres;

import ch.software_atelier.simpleflex.rest.DefaultRestResource;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.ExceptionHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.auth.utils.JSONHelper;
import ch.software_atelier.simpleflex.rest.swagger.BodyParameter;
import ch.software_atelier.simpleflex.rest.swagger.HeaderParameter;
import ch.software_atelier.simpleflex.rest.swagger.MethodDocumentation;
import ch.software_atelier.simpleflex.rest.swagger.ObjectSchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.Parameter;
import ch.software_atelier.simpleflex.rest.swagger.PathParameter;
import java.util.HashMap;
import org.json.JSONObject;

public class UserSettingsResource
extends DefaultRestResource {
    private final TokenHandler _th;
    private final DataHandler _dh;
    private final TokenParser _tp;

    public UserSettingsResource(DataHandler dh, TokenHandler th, TokenParser tp) {
        this._dh = dh;
        this._th = th;
        this._tp = tp;
    }

    public RestResponse onPUT(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String userByToken = this._tp.getUsername(token);
            String userByPath = request.getResourcePlaceholder("name");
            if (this._tp.isAdmin(token) || userByToken.equals(userByPath)) {
                JSONObject settings = request.getJSON();
                HashMap settingsMap = JSONHelper.jsonToHashmap(settings);
                this._dh.putUserSettings(userByPath, settingsMap);
                return RestResponse.json_200((JSONObject)settings);
            }
            return RestResponse.unauthorized_401();
        }
        catch (DataHandlerException | TokenHandlerException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docPUT(MethodDocumentation request) {
        request.setTitle("Put User Settings");
        request.addTag("Authorisazion");
        request.setDescription("Saves the users settings if they belong to him or if the requesting user has admin previliges.\r\nSettings consist of key/value-pairs.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the username"));
        request.addParameter((Parameter)new BodyParameter("body", ObjectSchemaBuilder.create((String)"the settings object with key/value-pairs").toJSON()));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"the settings object with key/value-pairs").toJSON());
    }

    public RestResponse onGET(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            String userByToken = this._tp.getUsername(token);
            String userByPath = request.getResourcePlaceholder("name");
            if (this._tp.isAdmin(token) || userByToken.equals(userByPath)) {
                JSONObject result = JSONHelper.hashMapToJSON(this._dh.getUserSettings(userByPath));
                return RestResponse.json_200((JSONObject)result);
            }
            return RestResponse.unauthorized_401();
        }
        catch (DataHandlerException | TokenHandlerException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docGET(MethodDocumentation request) {
        request.setTitle("Get User Settings");
        request.addTag("Authorisazion");
        request.setDescription("Returns the users settings if they belong to him or if the requesting user has admin previliges.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new PathParameter("name", "the username"));
        request.addResponse("200", "OK", ObjectSchemaBuilder.create((String)"the users settings").toJSON());
    }
}

