/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.token;

import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.utils.JSONHelper;
import ch.software_atelier.simpleflex.rest.auth.utils.StrHlp;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.json.JSONObject;

public class TokenParser {
    private final String _secret;

    public TokenParser(String secret) {
        this._secret = secret;
    }

    public String getToken(RestRequest req) {
        try {
            String token;
            if (req.getHeaderValue("Authorization") != null) {
                String header = req.getHeaderValue("Authorization");
                StringTokenizer st = new StringTokenizer(header);
                st.nextToken();
                return st.nextToken();
            }
            if (req.getHeaderValue("Cookie") != null && (token = this.extractToken(req.getHeaderValue("Cookie"))) != null) {
                return token;
            }
            return req.getRequestArgument("token");
        }
        catch (NullPointerException | NoSuchElementException e) {
            return null;
        }
    }

    private String extractToken(String cookie) {
        StringTokenizer t = new StringTokenizer(cookie, ";");
        while (t.hasMoreTokens()) {
            String nameValue = t.nextToken().trim();
            if (!nameValue.startsWith("auth=")) continue;
            return nameValue.substring(5);
        }
        return null;
    }

    public boolean isAdmin(String token) throws TokenHandlerException {
        Map claims = this.getClaims(token);
        return (Boolean)claims.get("admin");
    }

    public String getUsername(String token) throws TokenHandlerException {
        Map claims = this.getClaims(token);
        return claims.get("username").toString();
    }

    public boolean allowes(String token, JSONObject fields) throws TokenHandlerException {
        Map claims = this.getClaims(token);
        for (String key : fields.keySet()) {
            if (claims.containsKey(key)) {
                if (fields.get(key).equals(claims.get(key))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isAuthorized(String token, String realm) throws TokenHandlerException {
        return this.getRealms(token).contains(realm);
    }

    public boolean verifyACL(String path, String token) throws TokenHandlerException {
        try {
            List<String> pathItems = StrHlp.tokenize(path, "/");
            Map claims = this.getClaims(token);
            Map mapACL = (Map)claims.get("acl");
            JSONObject jACL = JSONHelper.mapToJSON(mapACL);
            boolean allowed = false;
            if (JSONHelper.getAtPath(jACL, "/_access") != null) {
                allowed = (Boolean)JSONHelper.getAtPath(jACL, "/_access");
            }
            StringBuffer jPath = new StringBuffer();
            for (String item : pathItems) {
                Object oValue;
                Object o = JSONHelper.getAtPath(jACL, new StringBuffer().append(jPath).append("/").append(item).toString());
                if (o == null) {
                    oValue = JSONHelper.getAtPath(jACL, jPath + "/_other/_access");
                    jPath.append("/_other");
                } else {
                    oValue = JSONHelper.getAtPath(jACL, jPath + "/" + item + "/_access");
                    jPath.append("/").append(item);
                }
                if (oValue == null) continue;
                allowed = (Boolean)oValue;
            }
            return allowed;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public ArrayList<String> getRealms(String token) throws TokenHandlerException {
        Map claims = this.getClaims(token);
        ArrayList realms = (ArrayList)claims.get("realms");
        return realms;
    }

    public Map getClaims(String token) throws TokenHandlerException {
        try {
            Jwt jwt = Jwts.parserBuilder().setSigningKey(this._secret.getBytes("UTF-8")).build().parse(token);
            return (Map)jwt.getBody();
        }
        catch (UnsupportedEncodingException uee) {
            throw new TokenHandlerException(-100);
        }
        catch (ExpiredJwtException ee) {
            throw new TokenHandlerException(-2);
        }
        catch (SignatureException se) {
            throw new TokenHandlerException(-1);
        }
        catch (MalformedJwtException | UnsupportedJwtException | IllegalArgumentException iae) {
            throw new TokenHandlerException(-3);
        }
    }
}

