/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth;

import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import org.json.JSONException;

public class ExceptionHandler {
    public static RestResponse handle(Throwable th, boolean handleNullpointer) {
        if (th instanceof TokenHandlerException) {
            return ExceptionHandler.tokenHandler((TokenHandlerException)th);
        }
        if (th instanceof DataHandlerException) {
            return ExceptionHandler.dataHandler((DataHandlerException)th);
        }
        if (th instanceof JSONException) {
            return RestResponse.badRequest_400((Object)"Invalid payload");
        }
        if (th instanceof NullPointerException && handleNullpointer) {
            return RestResponse.badRequest_400((Object)"Invalid payload");
        }
        return RestResponse.internalServerError_500((Object)th.getMessage());
    }

    private static RestResponse tokenHandler(TokenHandlerException the) {
        switch (the.getCode()) {
            case -100: {
                return RestResponse.internalServerError_500((Object)"Something went wrong. Probably an issue with the database.");
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                return RestResponse.unauthorized_401();
            }
        }
        return RestResponse.internalServerError_500((Object)"Something went wrong. Probably an issue with the database.");
    }

    private static RestResponse dataHandler(DataHandlerException dhe) {
        switch (dhe.getErrCode()) {
            case 0: {
                return RestResponse.notFound_404();
            }
            case -1: {
                return RestResponse.unauthorized_401();
            }
            case -100: {
                return RestResponse.internalServerError_500((Object)"Something went wrong. Probably an issue with the database.");
            }
        }
        return RestResponse.internalServerError_500((Object)"Something terribly went wrong. Probably an issue with the database.");
    }
}

