/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.data;

import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.utils.YAML;
import com.google.gson.Gson;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import jakarta.xml.bind.DatatypeConverter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.json.JSONObject;

public class MongoDBDataHandler
implements DataHandler {
    private final MongoDatabase _db;
    private final MongoCollection<Document> _c;

    public MongoDBDataHandler(String uriStr) {
        MongoClientURI uri = new MongoClientURI(uriStr);
        MongoClient m = new MongoClient(uri);
        this._db = m.getDatabase(uri.getDatabase());
        for (String name : this._db.listCollectionNames()) {
            if (!name.equals("_auth")) continue;
            this._c = this._db.getCollection(name);
            return;
        }
        this._db.createCollection("_auth");
        this._c = this._db.getCollection("_auth");
    }

    @Override
    public void putUser(String user, String pass, boolean isAdmin) throws DataHandlerException {
        Document userObject = new Document();
        userObject.put("user", (Object)user);
        userObject.put("pass", (Object)MongoDBDataHandler.md5(pass));
        userObject.put("admin", (Object)isAdmin);
        userObject.put("type", (Object)"user");
        if (this.getUser(user) == null) {
            this._c.insertOne((Object)userObject);
        } else {
            Document set = new Document("$set", (Object)userObject);
            Document qry = new Document("user", (Object)user);
            qry.put("type", (Object)"user");
            this._c.updateOne((Bson)qry, (Bson)set);
        }
    }

    @Override
    public void putAdmin(String user, boolean isAdmin) throws DataHandlerException {
        if (this.getUser(user) == null) {
            throw new DataHandlerException(-1);
        }
        Document admin = new Document("admin", (Object)isAdmin);
        Document set = new Document("$set", (Object)admin);
        Document qry = new Document("user", (Object)user);
        this._c.updateOne((Bson)qry, (Bson)set);
    }

    @Override
    public void verifyUser(String user, String pass) throws DataHandlerException {
        Document userObject = this.getUser(user);
        if (userObject == null) {
            throw new DataHandlerException(-1);
        }
        String upass = userObject.get((Object)"pass").toString();
        if (!upass.equals(MongoDBDataHandler.md5(pass))) {
            throw new DataHandlerException(-1);
        }
    }

    @Override
    public void putUserSettings(String user, HashMap<String, String> settings) throws DataHandlerException {
        this.putMap(user, "settings", settings);
    }

    @Override
    public void putUserACL(String user, String acl) throws DataHandlerException {
        Document userObject = this.getUser(user);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        String jsonACL = "{}";
        if (!acl.trim().isEmpty()) {
            jsonACL = YAML.toJSON(acl).toString();
        }
        Document aclDoc = new Document("yaml", (Object)acl);
        aclDoc.put("json", (Object)jsonACL);
        Document set = new Document("$set", (Object)new Document("acl", (Object)aclDoc));
        Document qry = new Document("user", (Object)user);
        qry.put("type", (Object)"user");
        this._c.updateOne((Bson)qry, (Bson)set);
    }

    @Override
    public String getUserACLasYAML(String user) throws DataHandlerException {
        Gson gson = new Gson();
        Document userObject = this.getUser(user);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        String yaml = "";
        if (userObject.containsKey((Object)"acl")) {
            yaml = ((Document)userObject.get((Object)"acl", Document.class)).getString((Object)"yaml");
        }
        return yaml;
    }

    @Override
    public JSONObject getUserACLasJSON(String user) throws DataHandlerException {
        Gson gson = new Gson();
        Document userObject = this.getUser(user);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        String json = "{}";
        if (userObject.containsKey((Object)"acl")) {
            json = ((Document)userObject.get((Object)"acl", Document.class)).getString((Object)"json");
        }
        return new JSONObject(json);
    }

    @Override
    public HashMap<String, String> getUserSettings(String user) throws DataHandlerException {
        Document userObject = this.getUser(user);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        if (userObject.containsKey((Object)"settings")) {
            Document settingsObject = (Document)userObject.get((Object)"settings");
            Set keys = settingsObject.keySet();
            for (String key : keys) {
                settings.put(key, settingsObject.get((Object)key).toString());
            }
        }
        return settings;
    }

    @Override
    public void putRealms(String user, HashMap<String, String> realms) throws DataHandlerException {
        this.putMap(user, "realms", realms);
    }

    @Override
    public HashMap<String, String> getRealms(String user) throws DataHandlerException {
        return this.getMap(user, "realms");
    }

    @Override
    public boolean isAdmin(String user) throws DataHandlerException {
        Document userObj = this.getUser(user);
        if (userObj == null) {
            throw new DataHandlerException(0);
        }
        if (!userObj.containsKey((Object)"admin")) {
            return false;
        }
        return userObj.get((Object)"admin").toString().equals("true");
    }

    @Override
    public List<String> getUsers() {
        Document qry = new Document("type", (Object)"user");
        return this.getUsers(qry);
    }

    @Override
    public List<String> getUsersBySetting(String key, String value) {
        Document userQry = new Document("type", (Object)"user");
        Document settingsQry = new Document("settings." + key, (Object)value);
        Document andDoc = new Document("$and", Arrays.asList(userQry, settingsQry));
        return this.getUsers(andDoc);
    }

    private List<String> getUsers(Document doc) {
        FindIterable c = this._c.find((Bson)doc);
        ArrayList<String> userList = new ArrayList<String>();
        for (Document o : c) {
            userList.add(o.get((Object)"user").toString());
        }
        return userList;
    }

    @Override
    public List<String> getGroups() throws DataHandlerException {
        Document qry = new Document("type", (Object)"group");
        FindIterable c = this._c.find((Bson)qry);
        ArrayList<String> userList = new ArrayList<String>();
        for (Document o : c) {
            userList.add(o.get((Object)"name").toString());
        }
        return userList;
    }

    @Override
    public void deleteUser(String username) throws DataHandlerException {
        this._c.deleteOne((Bson)new Document("user", (Object)username));
    }

    private void putMap(String user, String field, HashMap<String, String> fields) throws DataHandlerException {
        if (this.getUser(user) == null) {
            throw new DataHandlerException(0);
        }
        Document settingsObj = new Document();
        Set<String> keys = fields.keySet();
        for (String key : keys) {
            settingsObj.put(key, (Object)fields.get(key));
        }
        this._c.updateOne((Bson)new Document("user", (Object)user), (Bson)new Document("$set", (Object)new Document(field, (Object)settingsObj)));
    }

    private HashMap<String, String> getMap(String user, String field) throws DataHandlerException {
        Document userObject = this.getUser(user);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        if (userObject.containsKey((Object)field)) {
            Document settingsObject = (Document)userObject.get((Object)field);
            Set keys = settingsObject.keySet();
            for (String key : keys) {
                fields.put(key, settingsObject.get((Object)key).toString());
            }
        }
        return fields;
    }

    private Document getUser(String user) {
        Document qry = new Document("user", (Object)user);
        qry.put("type", (Object)"user");
        return (Document)this._c.find((Bson)qry).first();
    }

    private Document getGroup(String name) {
        Document qry = new Document("name", (Object)name);
        qry.put("type", (Object)"group");
        return (Document)this._c.find((Bson)qry).first();
    }

    private static String md5(String pass) throws DataHandlerException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(pass.getBytes());
            byte[] digest = md.digest();
            return DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataHandlerException(-100);
        }
    }

    @Override
    public void setUserGroups(String name, List<String> groups) throws DataHandlerException {
        Document user = this.getUser(name);
        if (user == null) {
            throw new DataHandlerException(0);
        }
        Document set = new Document("groups", groups);
        Document query = new Document();
        query.put("type", (Object)"user");
        query.put("user", (Object)name);
        this._c.updateOne((Bson)query, (Bson)new Document("$set", (Object)set));
    }

    @Override
    public List<String> getUserGroups(String name) throws DataHandlerException {
        Document user = this.getUser(name);
        if (user == null) {
            throw new DataHandlerException(0);
        }
        ArrayList<String> groups = new ArrayList<String>();
        if (user.containsKey((Object)"groups")) {
            List loadedGroups = (List)user.get((Object)"groups", List.class);
            for (String group : loadedGroups) {
                if (this.getGroup(group) == null) continue;
                groups.add(group);
            }
        }
        return groups;
    }

    @Override
    public void putGroup(String name) throws DataHandlerException {
        Document groupObject = new Document();
        groupObject.put("name", (Object)name);
        groupObject.put("type", (Object)"group");
        if (this.getGroup(name) == null) {
            this._c.insertOne((Object)groupObject);
        }
    }

    @Override
    public JSONObject getGroupACLasJSON(String name) throws DataHandlerException {
        Gson gson = new Gson();
        Document userObject = this.getGroup(name);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        String json = "{}";
        if (userObject.containsKey((Object)"acl")) {
            json = ((Document)userObject.get((Object)"acl", Document.class)).getString((Object)"json");
        }
        return new JSONObject(json);
    }

    @Override
    public String getGroupACLasYAML(String name) throws DataHandlerException {
        Gson gson = new Gson();
        Document userObject = this.getGroup(name);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        String yaml = "";
        if (userObject.containsKey((Object)"acl")) {
            yaml = ((Document)userObject.get((Object)"acl", Document.class)).getString((Object)"yaml");
        }
        return yaml;
    }

    @Override
    public void putGroupACL(String name, String acl) throws DataHandlerException {
        Document userObject = this.getGroup(name);
        if (userObject == null) {
            throw new DataHandlerException(0);
        }
        String jsonACL = "{}";
        if (!acl.trim().isEmpty()) {
            jsonACL = YAML.toJSON(acl).toString();
        }
        Document aclDoc = new Document("yaml", (Object)acl);
        aclDoc.put("json", (Object)jsonACL);
        Document set = new Document("$set", (Object)new Document("acl", (Object)aclDoc));
        Document qry = new Document("name", (Object)name);
        qry.put("type", (Object)"group");
        this._c.updateOne((Bson)qry, (Bson)set);
    }

    @Override
    public void deleteGroup(String name) throws DataHandlerException {
        if (this._c.count((Bson)new Document("groups", (Object)name)) > 0L) {
            throw new DataHandlerException(-2);
        }
        Document qry = new Document();
        qry.put("name", (Object)name);
        qry.put("type", (Object)"group");
        this._c.deleteOne((Bson)qry);
    }
}

