/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.rres;

import ch.software_atelier.simpleflex.rest.DefaultRestResource;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.ExceptionHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenParser;
import ch.software_atelier.simpleflex.rest.auth.utils.JSONHelper;
import ch.software_atelier.simpleflex.rest.swagger.ArraySchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.BodyParameter;
import ch.software_atelier.simpleflex.rest.swagger.HeaderParameter;
import ch.software_atelier.simpleflex.rest.swagger.MethodDocumentation;
import ch.software_atelier.simpleflex.rest.swagger.ObjectSchemaBuilder;
import ch.software_atelier.simpleflex.rest.swagger.Parameter;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserResource
extends DefaultRestResource {
    private final DataHandler _dh;
    private final TokenHandler _th;
    private final TokenParser _tp;

    public UserResource(DataHandler dh, TokenHandler th, TokenParser tp) {
        this._tp = tp;
        this._dh = dh;
        this._th = th;
    }

    public RestResponse onGET(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            if (token == null) {
                return RestResponse.unauthorized_401();
            }
            if (this._tp.isAdmin(token)) {
                String key = request.getRequestArgument("key");
                String value = request.getRequestArgument("value");
                if (key != null && value != null) {
                    List<String> users = this._dh.getUsersBySetting(key, value);
                    JSONArray arr = JSONHelper.stringList2JSONArr(users);
                    return RestResponse.json_200((JSONArray)arr);
                }
                List<String> users = this._dh.getUsers();
                JSONArray arr = JSONHelper.stringList2JSONArr(users);
                return RestResponse.json_200((JSONArray)arr);
            }
            return RestResponse.unauthorized_401();
        }
        catch (TokenHandlerException the) {
            return RestResponse.unauthorized_401();
        }
        catch (NullPointerException | JSONException th) {
            return ExceptionHandler.handle(th, false);
        }
    }

    public void docGET(MethodDocumentation request) {
        request.setTitle("List Users");
        request.addTag("Authorisazion");
        request.setDescription("Returns a list of allusers, if the authenticated user has admin previliges.");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addResponse("200", "OK", ArraySchemaBuilder.create((String)"all users on this instance").setBasic("string", "a user").toJSON());
    }

    public RestResponse onPOST(RestRequest request) {
        try {
            String token = this._tp.getToken(request);
            if (!this._tp.isAdmin(token)) {
                return RestResponse.unauthorized_401();
            }
            JSONObject obj = request.getJSON();
            String user = obj.getString("user");
            String pass = obj.getString("pass");
            HashMap realms = JSONHelper.jsonToHashmap(obj.getJSONObject("realms"));
            boolean isAdmin = obj.getBoolean("admin");
            this._dh.putUser(user, pass, isAdmin);
            this._dh.putRealms(user, realms);
            return RestResponse.json_201_created((JSONObject)obj);
        }
        catch (DataHandlerException | TokenHandlerException | NullPointerException | JSONException th) {
            return ExceptionHandler.handle(th, true);
        }
    }

    public void docPOST(MethodDocumentation request) {
        request.setTitle("Create User");
        request.addTag("Authorisazion");
        request.setDescription("Creates a new user, if the requesting user has admin previliges");
        request.addProduces("application/json");
        request.addParameter((Parameter)new HeaderParameter("Authorization", "the access token, Baerer"));
        request.addParameter((Parameter)new BodyParameter("body", ObjectSchemaBuilder.create((String)"the user information").addSimpleProperty("user", "string", "the username", true).addSimpleProperty("pass", "string", "the password", true).addSimpleProperty("admin", "boolean", "wether the user is admin or not", true).addObjectProperty("realms", ObjectSchemaBuilder.create((String)"The realms. key: realmname, value: realmdescription").toJSON(), true).toJSON()));
        request.addResponse("201", "Created", new JSONObject());
    }
}

