/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.rres;

import ch.software_atelier.simpleflex.docs.impl.RedirectorDoc;
import ch.software_atelier.simpleflex.rest.DefaultRestResource;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResponse;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandler;
import ch.software_atelier.simpleflex.rest.auth.data.DataHandlerException;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandler;
import ch.software_atelier.simpleflex.rest.auth.token.TokenHandlerException;
import ch.software_atelier.simpleflex.rest.swagger.MethodDocumentation;

public class WebsiteLoginResource
extends DefaultRestResource {
    private final DataHandler dataHandler;
    private final TokenHandler tokenHandler;
    private final String successUrl;
    private final String failedUrl;
    private int sessionTimeoutInSeconds;

    public WebsiteLoginResource(DataHandler dh, TokenHandler th, String successUrl, String failedUrl, int sessionTimeoutInSeconds) {
        this.dataHandler = dh;
        this.tokenHandler = th;
        this.successUrl = successUrl;
        this.failedUrl = failedUrl;
        this.sessionTimeoutInSeconds = sessionTimeoutInSeconds;
    }

    public RestResponse onPOST(RestRequest request) {
        String username = new String(request.getData("user"));
        username = username.substring(0, username.length() - 2);
        String password = new String(request.getData("pass"));
        password = password.substring(0, password.length() - 2);
        try {
            this.dataHandler.verifyUser(username, password);
            RestResponse response = this.buildRedirect(this.successUrl);
            String token = this.tokenHandler.createToken(username, this.sessionTimeoutInSeconds);
            this.bakeCookie(response, token);
            return response;
        }
        catch (DataHandlerException | TokenHandlerException e) {
            return this.buildRedirect(this.failedUrl);
        }
    }

    public void docPOST(MethodDocumentation request) {
        super.docPOST(request);
    }

    private RestResponse buildRedirect(String url) {
        RedirectorDoc doc = new RedirectorDoc(url);
        RestResponse response = new RestResponse(doc.name(), doc.mime(), doc.byteData());
        return response;
    }

    private void bakeCookie(RestResponse response, String token) {
        response.addHeader("Set-Cookie:", "auth=" + token);
    }
}

