/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.auth.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONHelper {
    public static HashMap jsonToHashmap(JSONObject obj) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        try {
            Set keys = obj.keySet();
            for (String key : keys) {
                hm.put(key, obj.get(key));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hm;
    }

    public static JSONObject hashMapToJSON(HashMap hm) {
        JSONObject jo = new JSONObject();
        try {
            Object[] keys = hm.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                jo.put((String)keys[i], hm.get(keys[i]));
            }
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return jo;
    }

    public static JSONArray stringList2JSONArr(List<String> list) throws JSONException {
        JSONArray jArr = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            jArr.put((Object)list.get(i));
        }
        return jArr;
    }

    public static void deepMerge(JSONObject first, JSONObject second) {
        Set keys = first.keySet();
        for (String k : keys) {
            if (!second.has(k)) {
                second.put(k, first.get(k));
                continue;
            }
            if (first.get(k) instanceof JSONObject && second.get(k) instanceof JSONObject) {
                JSONHelper.deepMerge((JSONObject)first.get(k), (JSONObject)second.get(k));
                continue;
            }
            second.put(k, first.get(k));
        }
    }

    public static Object getAtPath(JSONObject o, String path) {
        return JSONHelper.getAtPath(o, "/", path);
    }

    public static Object getAtPath(JSONObject o, String separator, String path) {
        StringTokenizer st = new StringTokenizer(path, separator);
        try {
            Object node = o;
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                if (node instanceof JSONArray) {
                    node = JSONHelper.getFromArray((JSONArray)node, key);
                } else if (node instanceof JSONObject) {
                    node = node.get(key);
                } else if (st.hasMoreElements()) {
                    return null;
                }
                if (st.hasMoreElements()) continue;
                return node;
            }
        }
        catch (JSONException je) {
            return null;
        }
        return null;
    }

    private static Object getFromArray(JSONArray arr, String pos) {
        if (pos.equals("-")) {
            return arr.get(arr.length() - 1);
        }
        int p = Integer.parseInt(pos);
        return arr.get(p);
    }

    public static List<String> toStringList(JSONArray arr) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arr.length(); ++i) {
            list.add(arr.getString(i));
        }
        return list;
    }

    public static Map<String, Object> jsonToMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = JSONHelper.jsonToList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JSONHelper.jsonToMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> jsonToList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = JSONHelper.jsonToList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JSONHelper.jsonToMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static JSONObject mapToJSON(Map<String, Object> data) {
        JSONObject result = new JSONObject();
        for (String key : data.keySet()) {
            Object value = data.get(key);
            Object jValue = value instanceof Map ? JSONHelper.mapToJSON((Map)value) : (value instanceof List ? JSONHelper.listToJSON((List)value) : value);
            result.put(key, jValue);
        }
        return result;
    }

    public static JSONArray listToJSON(List list) {
        JSONArray result = new JSONArray();
        for (Object o : list) {
            if (o instanceof Map) {
                result.put((Object)JSONHelper.mapToJSON((Map)o));
                continue;
            }
            if (o instanceof List) {
                result.put((Object)JSONHelper.listToJSON((List)o));
                continue;
            }
            result.put(o);
        }
        return result;
    }
}

