/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    public static String getMimeFromFilePath(String path) {
        JSONObject o = new JSONObject(Utils.getResource("mime.json"));
        StringTokenizer t = new StringTokenizer(path, ".");
        String extension = "default";
        while (t.hasMoreTokens()) {
            extension = t.nextToken();
        }
        if (o.has(extension)) {
            return o.getString(extension);
        }
        return o.getString("default");
    }

    public static String getResource(String name) {
        StringBuilder result = new StringBuilder();
        ClassLoader classLoader = Utils.class.getClassLoader();
        try (Scanner scanner = new Scanner(classLoader.getResourceAsStream(name));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                result.append(line).append("\n");
            }
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(Utils.getMimeFromFilePath("file."));
    }

    public static byte[] readBytesUntilNewLine(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int charAsInt = is.read();
        boolean eof = false;
        while (charAsInt != -1 && charAsInt != 10) {
            baos.write(charAsInt);
            if (is.available() >= 1) {
                charAsInt = is.read();
            }
            if (charAsInt != -1) continue;
            eof = true;
        }
        if (baos.toByteArray().length == 0 && eof) {
            return null;
        }
        baos.write(10);
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public static String readUntilNewLine(BufferedInputStream is, boolean trim) throws IOException {
        StringBuilder sb = new StringBuilder();
        int charAsInt = is.read();
        boolean eof = false;
        while (charAsInt != -1 && charAsInt != 10) {
            sb.append((char)charAsInt);
            if (is.available() >= 1) {
                charAsInt = is.read();
            }
            if (charAsInt != -1) continue;
            eof = true;
        }
        if (sb.length() == 0 && eof) {
            return null;
        }
        sb.append("\n");
        String line = sb.toString();
        if (trim) {
            line = line.trim();
        }
        return line;
    }

    private static String getCharter(String charAsHex) {
        Integer charAsInteger = Integer.valueOf(charAsHex, 16);
        int charAsInt = charAsInteger;
        return (char)charAsInt + "";
    }

    public static String[] splitHeader(String header) {
        StringTokenizer headerTokenizer = new StringTokenizer(header, ":");
        String key = null;
        String value = null;
        if (headerTokenizer.hasMoreTokens()) {
            key = headerTokenizer.nextToken();
        }
        if (headerTokenizer.hasMoreTokens()) {
            value = headerTokenizer.nextToken();
        }
        if (key != null && value != null) {
            return new String[]{key, value};
        }
        return null;
    }

    public static String getFileExtension(String fileName) {
        StringTokenizer st = new StringTokenizer(fileName, ".");
        String extension = "";
        while (st.hasMoreTokens()) {
            extension = st.nextToken();
        }
        System.out.println("Extension: " + extension);
        return extension;
    }

    public static String getHTTPDateHeaderValue(Date d) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(calendar.getTime());
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFile(File f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> tokenize(String src, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(src, separator);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static long parseLong(String s) {
        StringBuilder result = new StringBuilder();
        char[] chars = s.toCharArray();
        if (chars.length > 0 && chars[0] == '-') {
            result.append('-');
        }
        for (int i = 0; i < chars.length && !(chars[i] == '.' | chars[i] == ','); ++i) {
            if (!Character.isDigit(chars[i])) continue;
            result.append(chars[i]);
        }
        String resStr = result.toString();
        if (resStr.length() == 0) {
            return 0L;
        }
        return Long.parseLong(resStr);
    }

    public static JSONObject file2JSON(File f) throws IOException, JSONException {
        String content = new String(Utils.readFile(f));
        return new JSONObject(content);
    }

    public static List<String> tokenizeByIgnoringEnclosure(String src, char separator, char enclosure) {
        ArrayList<String> list = new ArrayList<String>();
        boolean enclosed = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            String c = src.substring(i, i + 1);
            if (enclosed && c.equals(enclosure + "")) {
                sb.append(c);
                enclosed = false;
                continue;
            }
            if (c.equals(enclosure + "")) {
                sb.append(c);
                enclosed = true;
                continue;
            }
            if (enclosed) {
                sb.append(c);
                continue;
            }
            if (c.equals(separator + "")) {
                list.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String removeNonEscaped(String src, char remove, char escape) {
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            String c = src.substring(i, i + 1);
            if (escaped) {
                sb.append(c);
                escaped = false;
                continue;
            }
            if (c.equals(escape + "")) {
                escaped = true;
                continue;
            }
            if (c.equals(remove + "")) continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

