/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.docs.impl;

import bsh.EvalError;
import bsh.Interpreter;
import ch.software_atelier.simpleflex.Request;
import ch.software_atelier.simpleflex.SimpleFlexAccesser;
import ch.software_atelier.simpleflex.docs.HeaderField;
import ch.software_atelier.simpleflex.docs.WebDoc;
import ch.software_atelier.simpleflex.docs.impl.BeanShellDocException;
import ch.software_atelier.simpleflex.docs.impl.ErrorDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class BeanShellDoc
extends WebDoc {
    private static File _src;
    private static final String _BSH_SEPERATOR_START = "<!bsh";
    private static final String _BSH_SEPERATOR_END = "!>";
    private final Interpreter _interpr = new Interpreter();
    private String _mime = "text/html";
    private String _name = "";
    private final ArrayList _codes = new ArrayList();
    private final ArrayList _staticContent = new ArrayList();
    private byte[] _data;

    public BeanShellDoc(File file) throws BeanShellDocException {
        this._name = file.getName();
        _src = file;
        this.genParts(file);
    }

    public void genDoc(Request request, SimpleFlexAccesser sfa) {
        try {
            int httpCode = this.getHttpCode().code;
            String httpMsg = this.getHttpCode().message;
            this._interpr.set("sf_httpCode", httpCode);
            this._interpr.set("sf_httpMsg", (Object)httpMsg);
            this._interpr.set("sf_headerKeys", new ArrayList());
            this._interpr.set("sf_headerValues", new ArrayList());
            this._interpr.set("sf_src", (Object)_src);
            this._interpr.set("sf_sfa", (Object)sfa);
            this._interpr.set("sf_request", (Object)request);
            this._interpr.set("sf_mime", (Object)this._mime);
            this._interpr.eval("sf_returnValue = new StringBuffer();\npublic void out(String value){\nsf_returnValue.append(value+\"\\n\");\n}\n");
            this._interpr.eval("public void header(String key, String value){sf_headerKeys.add(key);sf_headerValues.add(value);}");
            this._interpr.eval("public void code(int code, String msg){sf_httpCode=code;sf_httpMsg=msg;}");
            this._interpr.eval("public void mime(String mime){sf_mime=mime;}");
            StringBuffer doc = new StringBuffer();
            doc.append((String)this._staticContent.get(0));
            for (int i = 0; i < this._codes.size(); ++i) {
                doc.append(this.exec((String)this._codes.get(i)));
                doc.append((String)this._staticContent.get(i + 1));
            }
            httpCode = (Integer)this._interpr.get("sf_httpCode");
            httpMsg = (String)this._interpr.get("sf_httpMsg");
            this.setHTTPCode(httpCode, httpMsg);
            this._mime = (String)this._interpr.get("sf_mime");
            ArrayList headerKeys = (ArrayList)this._interpr.get("sf_headerKeys");
            ArrayList headerValues = (ArrayList)this._interpr.get("sf_headerValues");
            for (int i = 0; i < headerKeys.size(); ++i) {
                this.getHeaders().add(new HeaderField((String)headerKeys.get(i), (String)headerValues.get(i)));
            }
            this._data = doc.toString().getBytes();
        }
        catch (EvalError ee) {
            this._data = new ErrorDoc(ee.getMessage()).byteData();
        }
        catch (Exception e) {
            this._data = new ErrorDoc(e.getMessage()).byteData();
        }
    }

    private String exec(String code) {
        StringBuilder sb = new StringBuilder();
        try {
            this._interpr.eval(code);
            Object ret = this._interpr.get("sf_returnValue");
            this._interpr.eval("sf_returnValue = new StringBuffer();");
            return ret.toString();
        }
        catch (Throwable ioe) {
            return "Exception: " + ioe.getMessage();
        }
    }

    private void genParts(File file) throws BeanShellDocException {
        try {
            int i;
            FileInputStream fis = new FileInputStream(file);
            ByteBuffer bb = ByteBuffer.allocate((int)file.length());
            while ((i = fis.read()) != -1) {
                bb.put((byte)i);
            }
            String docAsString = new String(bb.array());
            String[] splitedByStartExpression = docAsString.split(_BSH_SEPERATOR_START);
            this._staticContent.add(splitedByStartExpression[0]);
            for (i = 1; i < splitedByStartExpression.length; ++i) {
                String[] splited = splitedByStartExpression[i].split(_BSH_SEPERATOR_END);
                if (splited.length != 2) {
                    throw new BeanShellDocException(new Exception(), BeanShellDocException.EXCEPTION_INVALIDE_PART);
                }
                this._staticContent.add(splited[1]);
                this._codes.add(splited[0]);
            }
        }
        catch (IOException ioe) {
            throw new BeanShellDocException(ioe, BeanShellDocException.EXCEPTION_FILE_IO);
        }
    }

    private Interpreter testBscCode(String code, int pos) throws BeanShellDocException {
        Interpreter i = new Interpreter();
        try {
            Object object = i.eval(code);
        }
        catch (EvalError bsee) {
            throw new BeanShellDocException(bsee, pos);
        }
        return i;
    }

    @Override
    public long size() {
        return this._data.length;
    }

    @Override
    public String mime() {
        return this._mime;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public byte[] byteData() {
        return this._data;
    }

    @Override
    public InputStream streamData() {
        return null;
    }

    @Override
    public String dataType() {
        return "BYTE";
    }

    @Override
    public void close() {
    }
}

