/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.docs.impl;

import ch.software_atelier.simpleflex.docs.WebDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateDoc
extends WebDoc {
    private String _templ;
    private final ArrayList _values = new ArrayList();
    private final ArrayList _placeholders = new ArrayList();
    private byte[] _templRes = new byte[0];
    private String _name;
    private String _placeholderPrefix = "<!--";
    private String _placeholderSuffix = "-->";

    public TemplateDoc(File file, String prefix, String suffix) throws IOException {
        this(file);
        this._placeholderPrefix = prefix;
        this._placeholderSuffix = suffix;
    }

    public TemplateDoc(File file) throws IOException {
        this._name = file.getName();
        FileInputStream fis = new FileInputStream(file);
        ByteBuffer bb = ByteBuffer.allocate((int)file.length());
        int i = 0;
        while ((i = fis.read()) != -1) {
            bb.put((byte)i);
        }
        this._templ = new String(bb.array());
    }

    public void add(String placeholder, String value) {
        this._values.add(value);
        this._placeholders.add(this._placeholderPrefix + placeholder + this._placeholderSuffix);
        this._templRes = new byte[0];
    }

    public void replace() {
        String tmplResult = this._templ;
        for (int i = 0; i < this._values.size(); ++i) {
            Pattern pattern = Pattern.compile((String)this._placeholders.get(i));
            Matcher matcher = pattern.matcher(tmplResult);
            tmplResult = matcher.replaceAll((String)this._values.get(i));
        }
        this._templRes = tmplResult.getBytes();
    }

    public void clear() {
        this._values.clear();
        this._placeholders.clear();
    }

    @Override
    public long size() {
        return this._templRes.length;
    }

    @Override
    public String mime() {
        return "text/html";
    }

    @Override
    public String name() {
        return "_name";
    }

    @Override
    public byte[] byteData() {
        return this._templRes;
    }

    @Override
    public InputStream streamData() {
        return null;
    }

    @Override
    public String dataType() {
        return "BYTE";
    }

    @Override
    public void close() {
    }
}

