/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.docs.impl;

import ch.software_atelier.simpleflex.docs.WebDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipDoc
extends WebDoc {
    private InputStream _is;
    private String _fileName;
    private File _tmpFile;

    public ZipDoc(File[] files, String fileName) {
        try {
            this._tmpFile = File.createTempFile("zip", "zip");
            this._tmpFile.deleteOnExit();
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this._tmpFile));){
                for (int i = 0; i < files.length; ++i) {
                    int len;
                    ZipEntry zipEntry = new ZipEntry(files[i].getName());
                    zipEntry.setSize(files[i].length());
                    zipEntry.setTime(files[i].lastModified());
                    zipEntry.setComment("Ziped by SimpleFlex DataStore!");
                    FileInputStream fis = new FileInputStream(files[i]);
                    zos.putNextEntry(zipEntry);
                    byte[] buf = new byte[2048];
                    while ((len = fis.read(buf)) > 0) {
                        zos.write(buf, 0, len);
                    }
                }
                zos.flush();
            }
            this._is = new FileInputStream(this._tmpFile);
            this._fileName = fileName;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public long size() {
        return this._tmpFile.length();
    }

    @Override
    public String mime() {
        return "application/zip";
    }

    @Override
    public String name() {
        return this._fileName;
    }

    @Override
    public byte[] byteData() {
        return null;
    }

    @Override
    public InputStream streamData() {
        return this._is;
    }

    @Override
    public String dataType() {
        return "STREAM";
    }

    @Override
    public void close() {
        this._tmpFile.delete();
    }
}

