/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.conf;

import ch.software_atelier.simpleflex.Utils;
import ch.software_atelier.simpleflex.conf.ConfigGenerator;
import ch.software_atelier.simpleflex.conf.DomainConfig;
import ch.software_atelier.simpleflex.conf.GlobalConfig;
import ch.software_atelier.simpleflex.conf.WebAppConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONConfigGenerator
implements ConfigGenerator {
    static Logger LOG = LogManager.getLogger(JSONConfigGenerator.class);
    private GlobalConfig _globalConfig = new GlobalConfig();
    private List<DomainConfig> _domainConfigs = new ArrayList<DomainConfig>();

    public JSONConfigGenerator(File jsonFile) {
        try {
            JSONObject obj = Utils.file2JSON(jsonFile);
            this.loadGlobalConfig(obj);
            this.loadDomains(obj);
        }
        catch (IOException | JSONException e) {
            LOG.error("Error in configuration", e);
        }
    }

    private void loadGlobalConfig(JSONObject obj) throws JSONException {
        int port = obj.optInt("port", 8080);
        this._globalConfig.setPort(port);
        if (obj.optBoolean("file_interface", false)) {
            this._globalConfig.setUseFileInterface(true);
            this._globalConfig.setFileInterfaceFile(new File(obj.optString("file_interface_path", "./fileInterface")));
            this._globalConfig.setFileInterfaceInterval(obj.optInt("file_interface_interval", 60000));
        }
    }

    private void loadDomains(JSONObject obj) throws JSONException {
        JSONArray arr = obj.optJSONArray("domains");
        if (arr == null) {
            System.err.println("No domains specified...");
            return;
        }
        for (int i = 0; i < arr.length(); ++i) {
            JSONArray apps;
            String name;
            JSONObject jDomain = arr.optJSONObject(i);
            if (jDomain == null || (name = jDomain.optString("name")).length() <= 0) continue;
            DomainConfig dc = new DomainConfig(name);
            JSONObject jdefaultWebApp = jDomain.optJSONObject("default_app");
            WebAppConfig dwac = this.loadWebAppConfig(jdefaultWebApp);
            if (dwac != null) {
                dc.setDefaultWebAppConfig(dwac);
            }
            if ((apps = jDomain.optJSONArray("apps")) != null) {
                for (int ii = 0; ii < apps.length(); ++ii) {
                    WebAppConfig wac;
                    JSONObject japp = apps.optJSONObject(ii);
                    if (japp == null || (wac = this.loadWebAppConfig(japp)) == null) continue;
                    dc.appendWebApp(wac);
                }
            }
            this._domainConfigs.add(dc);
        }
    }

    private WebAppConfig loadWebAppConfig(JSONObject obj) {
        String cp = obj.optString("classpath");
        String name = obj.optString("name");
        if (cp.length() > 0) {
            WebAppConfig wac = new WebAppConfig(cp, name);
            JSONObject config = obj.optJSONObject("config");
            if (config != null) {
                this.loadConfigToHashMap(config, wac.config());
            }
            return wac;
        }
        return null;
    }

    private void loadConfigToHashMap(JSONObject config, HashMap<String, Object> ht) {
        Set keys = config.keySet();
        for (String key : keys) {
            ht.put(key, config.opt(key));
        }
    }

    @Override
    public GlobalConfig globalConfig() {
        return this._globalConfig;
    }

    @Override
    public List<DomainConfig> domainConfigs() {
        return this._domainConfigs;
    }
}

