/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.docs.impl;

import ch.software_atelier.simpleflex.Request;
import ch.software_atelier.simpleflex.Utils;
import ch.software_atelier.simpleflex.docs.WebDoc;
import ch.software_atelier.simpleflex.docs.impl.FileDocException;
import ch.software_atelier.simpleflex.docs.impl.FolderRedirectorDoc;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileDoc
extends WebDoc {
    private File _file;
    private boolean _delete = false;

    public FileDoc(File file) throws FileDocException {
        this(file, false);
    }

    public FileDoc(File file, boolean delete) throws FileDocException {
        if (!file.isFile() && !(file = new File(file, "index.html")).exists()) {
            throw new FileDocException("The File " + file.getAbsolutePath() + " does not exists!");
        }
        if (!file.exists()) {
            throw new FileDocException("The File " + file.getAbsolutePath() + " does not exists!");
        }
        this._file = file;
        this._delete = delete;
    }

    public static WebDoc fileByReq(Request req, File baseDir, String appName) throws FileDocException {
        String path = req.getReqestString().substring(appName.length() + 1);
        File file = new File(baseDir, path);
        if (file.isFile()) {
            return new FileDoc(file);
        }
        if (file.isDirectory() && !file.getAbsolutePath().endsWith("/")) {
            return new FolderRedirectorDoc(req.getReqestString());
        }
        if (!(file = new File(file, "index.html")).exists()) {
            throw new FileDocException("The File " + file.getAbsolutePath() + " does not exists!");
        }
        return new FileDoc(file);
    }

    public FileDoc(Request req, File baseDir) throws FileDocException {
        String path = req.getReqestString();
        File file = new File(baseDir, path);
        if (!file.isFile() && !(file = new File(file, "index.html")).exists()) {
            throw new FileDocException("The File " + file.getAbsolutePath() + " does not exists!");
        }
        if (!file.exists()) {
            throw new FileDocException("The File " + file.getAbsolutePath() + " does not exists!");
        }
        this._file = file;
    }

    @Override
    public long size() {
        return this._file.length();
    }

    @Override
    public String mime() {
        return Utils.getMimeFromFilePath(this._file.getName());
    }

    @Override
    public String name() {
        return this._file.getName();
    }

    @Override
    public byte[] byteData() {
        return null;
    }

    @Override
    public InputStream streamData() {
        BufferedInputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(this._file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return fis;
    }

    @Override
    public String dataType() {
        return "STREAM";
    }

    @Override
    public void close() {
        if (this._delete) {
            this._file.delete();
        }
    }
}

