/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import ch.software_atelier.simpleflex.Domain;
import ch.software_atelier.simpleflex.HTTPConnectionHandler;
import ch.software_atelier.simpleflex.HTTPSConnectionHandler;
import ch.software_atelier.simpleflex.NotReadyException;
import ch.software_atelier.simpleflex.apps.WebApp;
import ch.software_atelier.simpleflex.conf.GlobalConfig;
import ch.software_atelier.simpleflex.interfaces.file.FileInterfaceHandler;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SimpleFlexAccesser {
    private final GlobalConfig _gc;
    private HashMap<String, Domain> _domains;
    private final String _version;
    private final Date _startTime;
    private FileInterfaceHandler _fih = null;
    private HTTPConnectionHandler _http = null;
    private HTTPSConnectionHandler _https = null;
    boolean ready = false;

    public SimpleFlexAccesser(String version, Date startTime, GlobalConfig gc) {
        this._gc = gc;
        this._version = version;
        this._startTime = startTime;
    }

    public void setDomains(HashMap<String, Domain> domains) {
        this._domains = domains;
    }

    void setHTTPConnectionHandler(HTTPConnectionHandler http) {
        this._http = http;
    }

    void setHTTPSConnectionHandler(HTTPSConnectionHandler https) {
        this._https = https;
    }

    public void stopListening() {
        if (this._http != null) {
            this._http.stopListening();
        }
        if (this._https != null) {
            this._https.stopListening();
        }
    }

    public Date startTime() {
        return this._startTime;
    }

    public String version() {
        return this._version;
    }

    public void setFileInterfaceHandler(FileInterfaceHandler fih) {
        this._fih = fih;
    }

    public boolean ready() {
        return this.ready;
    }

    public void quitWebApps() throws NotReadyException {
        if (!this.ready) {
            throw new NotReadyException();
        }
        Collection<Domain> domains = this._domains.values();
        for (Domain d : domains) {
            List<WebApp> apps = d.apps();
            for (WebApp wapp : apps) {
                wapp.quit();
            }
        }
    }

    public void quitFileInterface() throws NotReadyException {
        if (!this.ready) {
            throw new NotReadyException();
        }
        if (this._fih != null) {
            this._fih.stop();
        }
    }

    public String getDomain(WebApp wa) throws NotReadyException {
        if (!this.ready) {
            throw new NotReadyException();
        }
        Collection<Domain> domains = this._domains.values();
        for (Domain d : domains) {
            String domainName = d.name();
            List<WebApp> apps = d.apps();
            for (WebApp wapp : apps) {
                if (!wa.equals(wapp)) continue;
                return domainName;
            }
        }
        return null;
    }

    public void shutDown() throws NotReadyException {
        this.quitWebApps();
        this.stopListening();
        this.quitFileInterface();
    }
}

