/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.docs.impl;

import ch.software_atelier.simpleflex.Utils;
import ch.software_atelier.simpleflex.docs.WebDoc;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class RessourceDoc
extends WebDoc {
    private byte[] _data = new byte[0];
    private String _name = "";
    private String _mime = "";

    public RessourceDoc(String path) {
        try {
            this._data = this.ressource2ByteArray(path);
            StringTokenizer st = new StringTokenizer(path, "/");
            while (st.hasMoreTokens()) {
                this._name = st.nextToken();
            }
            String ext = "";
            st = new StringTokenizer(this._name, ".");
            while (st.hasMoreTokens()) {
                ext = st.nextToken();
            }
            this._mime = Utils.getMime(ext);
        }
        catch (IOException e) {
            this._data = e.getMessage().getBytes();
            this._mime = "text/plain";
            this._name = "error.txt";
        }
    }

    private byte[] ressource2ByteArray(String path) throws IOException {
        ByteArrayOutputStream out;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(path);){
            int r;
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((r = in.read(buffer)) != -1) {
                out.write(buffer, 0, r);
            }
        }
        return out.toByteArray();
    }

    @Override
    public long size() {
        return this._data.length;
    }

    @Override
    public String mime() {
        return this._mime;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public byte[] byteData() {
        return this._data;
    }

    @Override
    public InputStream streamData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String dataType() {
        return "BYTE";
    }

    @Override
    public void close() {
    }
}

