/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import ch.software_atelier.simpleflex.RequestHandler;
import ch.software_atelier.simpleflex.WebAppHandler;
import ch.software_atelier.simpleflex.conf.GlobalConfig;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConnectionHandler
extends Thread {
    static Logger LOG = LogManager.getLogger(ConnectionHandler.class);
    private final GlobalConfig _gc;
    private final WebAppHandler _webAppHandler;
    private boolean _listening = false;
    private boolean _isListening = false;

    public ConnectionHandler(GlobalConfig gc, WebAppHandler webAppHandler) {
        this._gc = gc;
        this._webAppHandler = webAppHandler;
    }

    public void stopListening() {
        this._listening = false;
        while (this._isListening) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void run() {
        this._listening = true;
        this._isListening = true;
        try {
            ServerSocket ssocket = this.getServerSocket(this._gc);
            if (ssocket == null) {
                this._listening = false;
                this._isListening = false;
            }
            while (this._listening) {
                try {
                    Socket socket = ssocket.accept();
                    RequestHandler requestHandler = new RequestHandler(this._webAppHandler, socket, false);
                    requestHandler.start();
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
            if (this._isListening && ssocket != null) {
                ssocket.close();
                while (!ssocket.isClosed()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this._isListening = false;
            }
        }
        catch (IOException ioe) {
            LOG.error("", (Throwable)ioe);
        }
    }

    public abstract ServerSocket getServerSocket(GlobalConfig var1);
}

