/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import ch.software_atelier.simpleflex.RecievedData;
import ch.software_atelier.simpleflex.RecievedFile;
import ch.software_atelier.simpleflex.RecievedText;
import ch.software_atelier.simpleflex.RequestArgument;
import ch.software_atelier.simpleflex.RequestHandler;
import ch.software_atelier.simpleflex.UntilNewlineReader;
import ch.software_atelier.simpleflex.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import xmlwise.XmlElement;
import xmlwise.XmlParseException;
import xmlwise.Xmlwise;

public class Request {
    public static String CONTENT_TYPE_MULTIPART = "multipart/form-data";
    public static String CONTENT_TYPE_APPLICATION = "application/x-www-form-urlencoded";
    public static String CONTENT_TYPE_XML = "application/xml";
    public static String CONTENT_TYPE_JSON = "application/json";
    public static String CONTENT_TYPE_JSON_PATCH = "application/json-patch+json";
    private JSONObject _json = null;
    private JSONArray _jsonArr = null;
    private XmlElement _xml = null;
    private byte[] rawData = new byte[0];
    private final ArrayList<RecievedData> _recievedData;
    private String _protocoll;
    private String _method;
    private String _requestString;
    private final HashMap<String, String> _headerContent;
    private HashMap<String, Integer> _arrayCounter = new HashMap();
    private InetAddress _client;
    private boolean _secureConnection;
    private final ArrayList _arguments;
    private File _file;
    private String _fileName;
    public static final String HTTPHEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HTTPHEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HTTPHEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HTTPHEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HTTPHEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HTTPHEADER_ACCEPT = "Accept";
    public static final String HTTPHEADER_USER_AGENT = "User-Agent";
    public static final String HTTPHEADER_HOST = "Host";
    public static final String HTTPHEADER_REFERER = "Referer";
    public static final String HTTPHEADER_CONTENT_TYPE = "Content-Type";
    public static final String HTTPHEADER_CONNECTION = "Connection";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_PATCH = "PATCH";
    static Logger LOG = LogManager.getLogger(RequestHandler.class);

    public Request() {
        this._recievedData = new ArrayList();
        this._headerContent = new HashMap();
        this._arguments = new ArrayList();
    }

    protected boolean addHeaderLine(String line) {
        StringTokenizer st = new StringTokenizer(line, ":");
        if (!st.hasMoreElements()) {
            return false;
        }
        String key = st.nextToken();
        if (line.length() <= key.length() + 1) {
            return false;
        }
        String value = line.substring(key.length() + 1, line.length()).trim();
        this._headerContent.put(key, value);
        return true;
    }

    public void setSecure(boolean secure) {
        this._secureConnection = secure;
    }

    public void setClient(InetAddress client) {
        this._client = client;
    }

    public void setProtocoll(String protocoll) {
        this._protocoll = protocoll;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setRequestString(String requestString) {
        StringTokenizer st = new StringTokenizer(requestString, "?");
        this._requestString = this.decode(st.nextToken());
        if (st.hasMoreTokens()) {
            String arguments = st.nextToken();
            StringTokenizer argumentTokenizer = new StringTokenizer(arguments, "&");
            while (argumentTokenizer.hasMoreTokens()) {
                String argVal = argumentTokenizer.nextToken();
                String key = null;
                String val = null;
                StringTokenizer argValTokenizer = new StringTokenizer(argVal, "=");
                if (argValTokenizer.hasMoreTokens()) {
                    key = argValTokenizer.nextToken();
                }
                if (argValTokenizer.hasMoreTokens()) {
                    val = argValTokenizer.nextToken();
                }
                if (key != null && val != null) {
                    this._arguments.add(new RequestArgument(this.decode(key), this.decode(val)));
                    continue;
                }
                if (argVal.length() <= 0) continue;
                this._arguments.add(new RequestArgument(this.decode(argVal), ""));
            }
        }
    }

    public RequestArgument[] arguments() {
        RequestArgument[] args = new RequestArgument[this._arguments.size()];
        args = this._arguments.toArray(args);
        return args;
    }

    public String getArgument(String key) {
        for (int i = 0; i < this._arguments.size(); ++i) {
            RequestArgument arg = (RequestArgument)this._arguments.get(i);
            if (!arg.key().equals(key)) continue;
            return arg.value();
        }
        return null;
    }

    private String decode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return str;
        }
    }

    public String getProtocoll() {
        return this._protocoll;
    }

    public String getMethod() {
        return this._method;
    }

    public String getReqestString() {
        return this._requestString;
    }

    public String getLastRequestStringComponent() {
        List<String> path = Utils.tokenize(this.getReqestString(), "/");
        return path.get(path.size() - 1);
    }

    public HashMap<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Set<String> keys = this._headerContent.keySet();
        for (String key : keys) {
            String value = this._headerContent.get(key);
            headers.put(key, value);
        }
        return headers;
    }

    public String getHeaderValue(String key) {
        if (this._headerContent.containsKey(key)) {
            return this._headerContent.get(key);
        }
        if (this._headerContent.containsKey(key.toLowerCase())) {
            return this._headerContent.get(key.toLowerCase());
        }
        return null;
    }

    public boolean isSecureConnection() {
        return this._secureConnection;
    }

    public String getHost() {
        return this.extractCalledHostByHeaderValue(this.getHeaderValue(HTTPHEADER_HOST));
    }

    public int getPort() {
        String port = this.extractCalledPortByHeaderValue(this.getHeaderValue(HTTPHEADER_HOST));
        return Integer.parseInt(port);
    }

    private String extractCalledHostByHeaderValue(String headerValue) {
        StringTokenizer st = new StringTokenizer(headerValue, ":");
        if (st.hasMoreTokens()) {
            return st.nextToken().trim();
        }
        return null;
    }

    private String extractCalledPortByHeaderValue(String headerValue) {
        StringTokenizer st = new StringTokenizer(headerValue, ":");
        if (!st.hasMoreTokens()) {
            return null;
        }
        st.nextToken();
        if (st.hasMoreTokens()) {
            return st.nextToken().trim();
        }
        if (this.isSecureConnection()) {
            return "443";
        }
        return "80";
    }

    public InetAddress getClient() {
        return this._client;
    }

    public void appendSinglePart(BufferedInputStream bis, long length) throws IOException {
        this._file = File.createTempFile("tmp", "bin");
        try (FileOutputStream fos = new FileOutputStream(this._file);){
            int maxBuffer = 32768;
            int buffersize = length < (long)maxBuffer ? (int)length : maxBuffer;
            byte[] buffer = new byte[buffersize];
            while (length > 0L) {
                int len = bis.read(buffer);
                fos.write(buffer, 0, len);
                buffersize = (length -= (long)buffersize) < (long)maxBuffer ? (int)length : maxBuffer;
            }
            fos.flush();
        }
    }

    public void apendMultipart(BufferedInputStream bis, long length) throws IOException {
        LOG.info("Adding multipart... " + length + "bytes");
        long l = length;
        long total_l = length;
        String boundaryString = this.getBoundary();
        String boundaryStringEnd = boundaryString + "--";
        String line = "";
        File tmp = File.createTempFile("file", ".tmp");
        try (FileOutputStream fos = new FileOutputStream(tmp);){
            int maxBuffer = 32768;
            int buffersize = length < (long)maxBuffer ? (int)length : maxBuffer;
            byte[] buffer = new byte[buffersize];
            while (length > 0L) {
                int len = bis.read(buffer);
                fos.write(buffer, 0, len);
                length -= (long)len;
            }
            fos.flush();
        }
        LOG.info("File saved. " + tmp.length() + "bytes");
        var13_10 = null;
        try (FileInputStream fis = new FileInputStream(tmp);){
            HashMap<String, String> headers = new HashMap<String, String>();
            RecievedData recievedData = null;
            boolean isHeader = true;
            boolean headerSaved = false;
            boolean isFirstBoundary = true;
            UntilNewlineReader unReader = new UntilNewlineReader(fis, 1024);
            byte[] data = unReader.read();
            line = new String(data);
            LOG.info("First line read: " + data.length + "bytes");
            long counter = 0L;
            while (!line.trim().endsWith(boundaryStringEnd)) {
                if (line.trim().endsWith(boundaryString)) {
                    if (isFirstBoundary) {
                        isFirstBoundary = false;
                    } else {
                        this._recievedData.add(recievedData);
                        recievedData.done();
                    }
                    isHeader = true;
                    headerSaved = false;
                } else if (isHeader && line.trim().equals("")) {
                    isHeader = false;
                }
                if (isHeader) {
                    String[] keyNValue = Utils.splitHeader(line);
                    if (keyNValue != null) {
                        headers.put(keyNValue[0].toUpperCase(), keyNValue[1]);
                    }
                } else if (!headerSaved) {
                    recievedData = this.saveHeaders(headers);
                    headerSaved = true;
                } else if (recievedData.type() == RecievedData.TYPE_FILE) {
                    ((RecievedFile)recievedData).apendToFile(data);
                } else if (recievedData.type() == RecievedData.TYPE_TEXT) {
                    ((RecievedText)recievedData).apendText(line);
                }
                data = unReader.read();
                l -= (long)data.length;
                if (++counter % 100L == 0L) {
                    System.out.println((int)(100.0 / (double)total_l * (double)l) + "%");
                }
                line = new String(data);
            }
            this._recievedData.add(recievedData);
            recievedData.done();
            LOG.info("Received Data added: " + recievedData.fieldName());
        }
        catch (Throwable throwable) {
            var13_10 = throwable;
            throw throwable;
        }
        tmp.delete();
    }

    private RecievedData saveHeaders(HashMap<String, String> headers) {
        RecievedData recievedData;
        String dispositionValue = headers.get(RecievedData._HEADER_CONTENT_DISPOSITION);
        StringTokenizer dispPartTokenizer = new StringTokenizer(dispositionValue, ";");
        String fieldName = null;
        String fileName = null;
        while (dispPartTokenizer.hasMoreTokens()) {
            String dispPart = dispPartTokenizer.nextToken().trim();
            if (dispPart.startsWith("name=\"")) {
                fieldName = dispPart.substring(6, dispPart.length() - 1).trim();
                continue;
            }
            if (!dispPart.startsWith("filename=\"")) continue;
            fileName = dispPart.substring(10, dispPart.length() - 1).trim();
        }
        if (fieldName.endsWith("[]")) {
            fieldName = fieldName.substring(0, fieldName.length() - 2);
            int pos = -1;
            if (this._arrayCounter.containsKey(fieldName)) {
                pos = this._arrayCounter.get(fieldName);
            }
            this._arrayCounter.put(fieldName, ++pos);
            fieldName = fieldName + "[" + pos + "]";
        }
        System.out.println(fieldName + ": " + fileName);
        if (fileName == null) {
            recievedData = new RecievedText();
        } else {
            recievedData = new RecievedFile();
            ((RecievedFile)recievedData).setFileName(fileName);
        }
        recievedData.setFieldName(fieldName);
        return recievedData;
    }

    public void apendURLEncoded(BufferedInputStream bfis, long length) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(new String(this.load(bfis, length)));
        StringTokenizer postTokenizer = new StringTokenizer(sb.toString(), "&");
        while (postTokenizer.hasMoreTokens()) {
            String element = postTokenizer.nextToken();
            StringTokenizer elementTokenizer = new StringTokenizer(element, "=");
            String key = null;
            String value = null;
            if (elementTokenizer.hasMoreTokens()) {
                key = elementTokenizer.nextToken();
            }
            if (elementTokenizer.hasMoreTokens()) {
                value = elementTokenizer.nextToken();
            }
            if (key == null || value == null) continue;
            RecievedText recievedText = new RecievedText();
            recievedText.setFieldName(key);
            recievedText.apendText(value);
            this.addRecievedData(recievedText);
        }
    }

    public void apendJSON(BufferedInputStream bfis, String charset, long length) throws IOException {
        String content = new String(this.load(bfis, length), charset);
        try {
            this._json = new JSONObject(content);
        }
        catch (JSONException jsone) {
            try {
                this._jsonArr = new JSONArray(content);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public void apendJSONArray(BufferedInputStream bfis, String charset, long length) throws IOException {
        try {
            this._jsonArr = new JSONArray(new String(this.load(bfis, length), charset));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void apendXML(BufferedInputStream bfis, String charset, long length) throws IOException {
        try {
            this._xml = Xmlwise.createXml((String)new String(this.load(bfis, length), charset));
        }
        catch (XmlParseException xmlParseException) {
            // empty catch block
        }
    }

    private byte[] load(BufferedInputStream bis, long length) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int buffersize = length < 512L ? (int)length : 512;
            byte[] buffer = new byte[buffersize];
            while (length > 0L) {
                int len = bis.read(buffer);
                bos.write(buffer, 0, len);
                buffersize = (length -= (long)buffersize) < 512L ? (int)length : 512;
            }
            bos.flush();
            byte[] byArray = this.rawData = bos.toByteArray();
            return byArray;
        }
    }

    private void addRecievedData(RecievedData rd) {
        this._recievedData.add(rd);
    }

    public RecievedData[] getRecievedData() {
        RecievedData[] rd = new RecievedData[this._recievedData.size()];
        rd = this._recievedData.toArray(rd);
        return rd;
    }

    public RecievedText getRecievedText(String field) {
        for (RecievedData rd : this._recievedData) {
            if (!rd.fieldName().equals(field) || !(rd instanceof RecievedText)) continue;
            return (RecievedText)rd;
        }
        return null;
    }

    public RecievedFile getRecievedFile(String field) {
        for (RecievedData rd : this._recievedData) {
            if (!rd.fieldName().equals(field) || !(rd instanceof RecievedFile)) continue;
            return (RecievedFile)rd;
        }
        return null;
    }

    public boolean isJSONReq() {
        return this._json != null;
    }

    public JSONObject getJSONReq() {
        return this._json;
    }

    public boolean isJSONArrReq() {
        return this._jsonArr != null;
    }

    public JSONArray getJSONArrReq() {
        return this._jsonArr;
    }

    public boolean isXMLReq() {
        return this._xml != null;
    }

    public XmlElement getXMLReq() {
        return this._xml;
    }

    public boolean isFormPostReq() {
        return this._recievedData.size() > 0;
    }

    public boolean isSinglePartReq() {
        return this._file != null;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public String getSinglePartFilename() {
        String headerValue = this.getHeaderValue(HTTPHEADER_CONTENT_DISPOSITION);
        if (headerValue != null) {
            List<String> pairs = Utils.tokenize(headerValue, ";");
            for (String pair : pairs) {
                List<String> pairList = Utils.tokenize(pair, "=");
                if (pairList.size() != 2 || !pairList.get(0).equals("filename")) continue;
                return pairList.get(1).substring(1, pairList.get(1).length() - 1);
            }
        }
        return null;
    }

    public String getSinglePartMimeType() {
        String headerValue = this.getHeaderValue(HTTPHEADER_CONTENT_TYPE);
        if (headerValue == null) {
            return null;
        }
        List<String> pairs = Utils.tokenize(headerValue, ";");
        if (pairs.isEmpty()) {
            return null;
        }
        return pairs.get(0);
    }

    public File getSinglePartFile() {
        return this._file;
    }

    public String getBoundary() {
        return this.extractBoundaryByHeaderValue(this.getHeaderValue(HTTPHEADER_CONTENT_TYPE));
    }

    private String extractBoundaryByHeaderValue(String headerValue) {
        StringTokenizer st = new StringTokenizer(headerValue, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.startsWith("boundary=")) continue;
            return token.substring(9, token.length()).trim();
        }
        return null;
    }

    public void cleanup() {
        if (this._file != null && !this._file.delete()) {
            this._file.deleteOnExit();
        }
    }
}

