/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.conf.text;

import ch.software_atelier.simpleflex.conf.text.ConfigElement;
import ch.software_atelier.simpleflex.conf.text.ConfigElementException;
import ch.software_atelier.simpleflex.conf.text.SyntaxErrorNotifiable;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConfigFileIO {
    private final ArrayList _configElements = new ArrayList();
    private final File _configFile;
    private final SyntaxErrorNotifiable _syntaxErrorNotifiable;

    public ConfigFileIO(File configFile, SyntaxErrorNotifiable sen) {
        this._configFile = configFile;
        this._syntaxErrorNotifiable = sen;
    }

    public void apendConfigElement(ConfigElement ce) {
        this._configElements.add(ce);
    }

    public ConfigElement[] configElements() {
        ConfigElement[] elements = new ConfigElement[this._configElements.size()];
        elements = this._configElements.toArray(elements);
        return elements;
    }

    public void read() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this._configFile)));
        String line = "";
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 2 || !line.startsWith("<") || !line.endsWith(">")) continue;
            String elementName = line.substring(1, line.length() - 1);
            this.apendConfigElement(this.readInConfigElement(elementName, br));
        }
    }

    private ConfigElement readInConfigElement(String elemName, BufferedReader br) throws IOException {
        String line;
        ConfigElement ce = new ConfigElement(elemName);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).equals("</" + elemName + ">")) {
                return ce;
            }
            if (line.equals("")) continue;
            String[] keyNValue = this.tokenizeKeyValue(line);
            if (keyNValue[0] != null && keyNValue[1] != null) {
                if (!keyNValue[0].equals("") && !keyNValue[1].equals("")) {
                    try {
                        ce.appendValue(keyNValue[0], keyNValue[1]);
                    }
                    catch (ConfigElementException configElementException) {}
                    continue;
                }
                this._syntaxErrorNotifiable.syntaxError("Invalide key/value-pair: " + line + " - ignored", false);
                continue;
            }
            this._syntaxErrorNotifiable.syntaxError("Invalide key/value-pair: " + line + " - ignored", false);
        }
        this._syntaxErrorNotifiable.syntaxError("Unclosed element! - " + line, true);
        return null;
    }

    private String[] tokenizeKeyValue(String line) {
        String[] keyNValue = new String[]{null, null};
        StringTokenizer st = new StringTokenizer(line, "=");
        if (st.hasMoreTokens()) {
            keyNValue[0] = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            keyNValue[1] = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this._syntaxErrorNotifiable.syntaxError("Invalide key/value-pair: " + line + " - ignored", false);
            return new String[]{null, null};
        }
        return keyNValue;
    }

    public void write() throws IOException {
        try (BufferedOutputStream bfos = new BufferedOutputStream(new FileOutputStream(this._configFile));){
            for (int i = 0; i < this._configElements.size(); ++i) {
                this.writeConfigElement((ConfigElement)this._configElements.get(i), bfos);
            }
        }
    }

    private void writeConfigElement(ConfigElement ce, BufferedOutputStream bos) throws IOException {
        bos.write(("<" + ce.elementName() + ">\n").getBytes());
        String[][] keyValueList = ce.getValuesAndKeysByRegexOfKey(".*");
        for (int i = 0; i < keyValueList[0].length; ++i) {
            bos.write((keyValueList[0][i] + "=" + keyValueList[1][i] + "\n").getBytes());
        }
        bos.write(("</" + ce.elementName() + ">\n").getBytes());
    }
}

