/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.interfaces.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FileInterfaceWriter {
    private final File _dst;
    private final ArrayList _commands = new ArrayList();
    private final long _timeout = 2000L;
    private int _reason = 0;
    private final String _newline = "\n";
    private static final String _STARTTAG = "<Interface>";
    private static final String _ENDTAG = "</Interface>";
    private static final String _KEY_CLASSPATH = "CLASSPATH";
    public static int ERRORCODE_TIMEOUT_EXPIERD = 1;
    public static int ERRORCODE_FILE_ALREADY_EXISTS = 2;
    public static int ERRORCODE_IOEXCEPTION = 3;
    public static int ERRORCODE_EVERYTHING_OK = 0;

    public FileInterfaceWriter(File dst) {
        this._dst = dst;
    }

    public void addCommand(String classPath, String[][] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(_STARTTAG);
        sb.append("\n");
        sb.append(_KEY_CLASSPATH);
        sb.append("=");
        sb.append(classPath);
        sb.append("\n");
        if (args.length > 0) {
            for (int i = 0; i < args[0].length; ++i) {
                sb.append(args[0][i]);
                sb.append("=");
                sb.append(args[1][i]);
                sb.append("\n");
            }
        }
        sb.append(_ENDTAG);
        this._commands.add(sb.toString());
    }

    public boolean execute() {
        try {
            if (this._dst.exists()) {
                this._reason = ERRORCODE_FILE_ALREADY_EXISTS;
                return false;
            }
            try (FileOutputStream fos = new FileOutputStream(this._dst);){
                for (int i = 0; i < this._commands.size(); ++i) {
                    fos.write(((String)this._commands.get(i)).getBytes());
                    fos.write("\n".getBytes());
                }
                fos.flush();
            }
            for (long t = 0L; t < 2000L; t += 50L) {
                if (!this._dst.exists()) {
                    this._reason = ERRORCODE_EVERYTHING_OK;
                    return true;
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (IOException ioe) {
            this._reason = ERRORCODE_IOEXCEPTION;
            return false;
        }
    }

    public int errorReason() {
        return this._reason;
    }
}

