/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.apps.defaultapp;

import ch.software_atelier.simpleflex.Request;
import ch.software_atelier.simpleflex.SimpleFlexAccesser;
import ch.software_atelier.simpleflex.apps.WebApp;
import ch.software_atelier.simpleflex.docs.WebDoc;
import ch.software_atelier.simpleflex.docs.impl.ErrorDoc;
import ch.software_atelier.simpleflex.docs.impl.FileDoc;
import ch.software_atelier.simpleflex.docs.impl.FileDocException;
import ch.software_atelier.simpleflex.docs.impl.FolderRedirectorDoc;
import java.io.File;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultApp
implements WebApp {
    private String _path;
    private String _name;
    private SimpleFlexAccesser _sfa;
    static Logger LOG = LogManager.getLogger(DefaultApp.class);

    @Override
    public void start(String name, HashMap<String, Object> config, SimpleFlexAccesser sfa) {
        this._sfa = sfa;
        String path = (String)config.get("$DOCPATH");
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this._path = path;
        this._name = name;
    }

    public boolean allowUpload(String path) {
        File file = new File(this._path, path);
        return file.exists();
    }

    @Override
    public long maxPostingSize(String requestedPath) {
        return 10240L;
    }

    @Override
    public WebDoc process(Request request) {
        if (!this.checkPath(request.getReqestString())) {
            return new ErrorDoc("??");
        }
        if (request.getMethod().equalsIgnoreCase("get")) {
            return this.handleGET(request);
        }
        return new ErrorDoc("method not allowed");
    }

    private WebDoc handleGET(Request request) {
        FolderRedirectorDoc webDoc = null;
        try {
            String req = this.cleanPath(request.getReqestString());
            File file = new File(this._path, req);
            if (file.isFile()) {
                if (file.getName().equals("PW")) {
                    return this.fileNotFound(req);
                }
                return new FileDoc(file);
            }
            if (request.getReqestString().endsWith("/")) {
                return this.handleIndex(request, file);
            }
            webDoc = new FolderRedirectorDoc(request.getReqestString());
        }
        catch (FileDocException fde) {
            return this.fileNotFound(request.getReqestString());
        }
        return webDoc;
    }

    private WebDoc handleIndex(Request req, File file) throws FileDocException {
        File indexFile = new File(file, "index.html");
        return new FileDoc(indexFile);
    }

    private WebDoc fileNotFound(String req) {
        return new ErrorDoc("404 - File not found");
    }

    private boolean checkPath(String path) {
        return !path.matches(".*\\/\\.\\.\\/.*");
    }

    @Override
    public void quit() {
    }

    private String cleanPath(String path) {
        if (this._name.length() == 0) {
            return path;
        }
        return path.substring(this._name.length() + 1, path.length());
    }
}

