/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.docs.impl;

import ch.software_atelier.simpleflex.docs.WebDoc;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONDoc
extends WebDoc {
    static Logger LOG = LogManager.getLogger(JSONDoc.class);
    private final String _data;
    private final String _mime;
    private final String _name;

    private JSONDoc(String data, String mime, String name) {
        this._data = data;
        this._mime = mime;
        this._name = name;
    }

    public static JSONDoc json(JSONObject data) {
        if (data.has("#array")) {
            try {
                return new JSONDoc(data.get("#array").toString(), "application/octet-stream; charset=utf-8", "text.json");
            }
            catch (JSONException e) {
                LOG.error("failed to parse JSONARRAY: " + data.get("#array").toString(), (Throwable)e);
                return new JSONDoc("[]", "application/octet-stream; charset=utf-8", "text.json");
            }
        }
        return new JSONDoc(data.toString(), "application/octet-stream; charset=utf-8", "text.json");
    }

    public static JSONDoc json(JSONArray data) {
        return new JSONDoc(data.toString(), "application/octet-stream; charset=utf-8", "text.json");
    }

    @Override
    public byte[] byteData() {
        try {
            return this._data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String dataType() {
        return "BYTE";
    }

    @Override
    public String mime() {
        return this._mime;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public long size() {
        try {
            return this._data.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            return 0L;
        }
    }

    @Override
    public InputStream streamData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

