/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.interfaces.file;

import ch.software_atelier.simpleflex.SimpleFlexAccesser;
import ch.software_atelier.simpleflex.conf.text.ConfigElement;
import ch.software_atelier.simpleflex.conf.text.ConfigFileIO;
import ch.software_atelier.simpleflex.conf.text.SyntaxErrorNotifiable;
import ch.software_atelier.simpleflex.interfaces.file.FileInterface;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileInterfaceHandler {
    private final File _interfaceFile;
    private final int _interval;
    private boolean _running = false;
    private final InterfaceFileListener _interfceFileListener;
    private final SimpleFlexAccesser _sfa;
    private static final String CLASSPATH = "CLASSPATH";
    static Logger LOG = LogManager.getLogger(FileInterfaceHandler.class);

    public FileInterfaceHandler(File interfaceFile, int interval, SimpleFlexAccesser sfa) {
        this._sfa = sfa;
        this._interfceFileListener = new InterfaceFileListener();
        this._interfaceFile = interfaceFile;
        this._interval = interval;
        if (this._interfaceFile.exists()) {
            this._interfaceFile.delete();
        }
    }

    public void start() {
        if (!this._running) {
            this._running = true;
            this._interfceFileListener.start();
        }
    }

    public void stop() {
        this._running = false;
    }

    private class InterfaceFileListener
    extends Thread
    implements SyntaxErrorNotifiable {
        private boolean _syntaxError = false;

        private InterfaceFileListener() {
        }

        @Override
        public void run() {
            while (FileInterfaceHandler.this._running) {
                if (FileInterfaceHandler.this._interfaceFile.exists()) {
                    ConfigElement[] configs = this.readFile();
                    if (!this._syntaxError) {
                        if (configs != null) {
                            for (int i = 0; i < configs.length; ++i) {
                                String[] classnames = configs[i].getValuesByKey(FileInterfaceHandler.CLASSPATH);
                                if (classnames.length == 1) {
                                    FileInterface fi = this.fileInterfaceByClassname(classnames[0]);
                                    if (fi != null) {
                                        String[][] configStrs = configs[i].getValuesAndKeysByRegexOfKey(".*");
                                        HashMap<String, Object> hash = new HashMap<String, Object>();
                                        for (int ii = 0; ii < configStrs[0].length; ++ii) {
                                            hash.put(configStrs[0][ii], configStrs[1][ii]);
                                        }
                                        boolean proc = fi.process(FileInterfaceHandler.this._sfa, hash);
                                        if (proc) continue;
                                        this.onProcFalse();
                                        continue;
                                    }
                                    this.onInvalideClasspath();
                                    continue;
                                }
                                this.onInvalideClasspath();
                            }
                        } else {
                            this.onSyntaxError();
                        }
                    } else {
                        this.onSyntaxError();
                    }
                    FileInterfaceHandler.this._interfaceFile.delete();
                    this._syntaxError = false;
                }
                try {
                    Thread.sleep(FileInterfaceHandler.this._interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private ConfigElement[] readFile() {
            try {
                ConfigFileIO cfIO = new ConfigFileIO(FileInterfaceHandler.this._interfaceFile, this);
                cfIO.read();
                if (!this._syntaxError) {
                    return cfIO.configElements();
                }
                return null;
            }
            catch (IOException ioe) {
                this._syntaxError = true;
                return null;
            }
        }

        private FileInterface fileInterfaceByClassname(String classname) {
            try {
                Class<?> fiClass = Class.forName(classname);
                Object fiObject = fiClass.newInstance();
                FileInterface fi = (FileInterface)fiObject;
                return fi;
            }
            catch (Throwable th) {
                LOG.error("Error on instanciate a FileInterface. Please check classpath.", th);
                return null;
            }
        }

        @Override
        public void syntaxError(String message, boolean fatal) {
            this._syntaxError = true;
            LOG.error(message);
        }

        private void onSyntaxError() {
            LOG.error("SyntaxError on reding on FileInterface");
        }

        private void onProcFalse() {
            LOG.error("FileInterface PlugIn not processing failed");
        }

        private void onInvalideClasspath() {
            LOG.error("Invalid CLASSPATH-Configuration");
        }

        private void onProcSucceeded(String classp) {
            LOG.info("process() sucessful > " + classp);
        }

        private void inProcUnSucceeded(String classp) {
            LOG.info("process() failed > " + classp);
        }
    }
}

