/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import ch.software_atelier.simpleflex.apps.WebApp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Domain {
    private final HashMap<String, WebApp> _webApps;
    private final String _name;
    private WebApp _defaultWebApp;

    public Domain(String name, HashMap<String, WebApp> webApps) {
        this._name = name;
        this._webApps = webApps;
    }

    public WebApp getDefaultWebApp() {
        return this._defaultWebApp;
    }

    public void setDefaultWebApp(WebApp defaultWebApp) {
        this._defaultWebApp = defaultWebApp;
    }

    public WebApp getWebApp(String name) {
        if (name == null) {
            return this._defaultWebApp;
        }
        WebApp webApp = this._webApps.get(name);
        if (webApp == null) {
            return this._defaultWebApp;
        }
        return webApp;
    }

    public String name() {
        return this._name;
    }

    public List<WebApp> apps() {
        ArrayList<WebApp> al = new ArrayList<WebApp>();
        al.add(this._defaultWebApp);
        Collection<WebApp> apps = this._webApps.values();
        for (WebApp app : apps) {
            al.add(app);
        }
        return al;
    }
}

