/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import ch.software_atelier.simpleflex.RecievedData;
import ch.software_atelier.simpleflex.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class RecievedFile
extends RecievedData {
    private File _file;
    private String _fileName = "";
    private BufferedOutputStream _fos;

    public RecievedFile() {
        try {
            this._file = File.createTempFile("sfRecFile", "tmp");
            this._fos = new BufferedOutputStream(new FileOutputStream(this._file, true));
        }
        catch (IOException ioe) {
            this._successfulReceived = false;
        }
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public String fileName() {
        return this._fileName;
    }

    @Override
    public int type() {
        return TYPE_FILE;
    }

    public File file() {
        return this._file;
    }

    public void apendToFile(byte[] data) {
        try {
            this._fos.write(data);
        }
        catch (IOException ioe) {
            this._successfulReceived = false;
        }
    }

    public byte[] getData() {
        return Utils.readFile(this._file);
    }

    public boolean successfulReceived() {
        return this._successfulReceived;
    }

    public void deleteTmpFile() {
        this._file.delete();
    }

    @Override
    public void done() {
        try {
            this._fos.flush();
            this._fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        if (this._file.exists() && !this._file.delete()) {
            this._file.deleteOnExit();
        }
    }
}

