/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import ch.software_atelier.simpleflex.LogMarker;
import ch.software_atelier.simpleflex.RecievedData;
import ch.software_atelier.simpleflex.RecievedFile;
import ch.software_atelier.simpleflex.Request;
import ch.software_atelier.simpleflex.Utils;
import ch.software_atelier.simpleflex.WebAppHandler;
import ch.software_atelier.simpleflex.apps.WebApp;
import ch.software_atelier.simpleflex.docs.HeaderField;
import ch.software_atelier.simpleflex.docs.WebDoc;
import ch.software_atelier.simpleflex.docs.impl.ErrorDoc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestHandler
extends Thread {
    static Logger LOG = LogManager.getLogger(RequestHandler.class);
    private final Socket _socket;
    private final WebAppHandler _webAppHandler;
    private PrintWriter _writer;
    private OutputStream _os;
    private BufferedInputStream _is;

    public RequestHandler(WebAppHandler webAppHandler, Socket socket, boolean secure) {
        this._webAppHandler = webAppHandler;
        this._socket = socket;
    }

    @Override
    public void run() {
        try {
            this.setupStreams();
            String req = Utils.readUntilNewLine(this._is, true);
            FirstLine fl = this.tokenizeFirstLine(req);
            if (fl.valid()) {
                if (fl.method.equals("OPTIONS")) {
                    this.sendOptionsHeader();
                    this.flushAndCloseSocket();
                    return;
                }
            } else {
                this.sendHeaderNotSupported();
                this.flushAndCloseSocket();
                return;
            }
            Request request = this.fillRequest(fl);
            String hostname = request.getHost();
            LOG.info(LogMarker.requestMarker(hostname), request.getReqestString());
            this.switchNow(request);
            if (request.getRecievedData().length > 0) {
                this.deleteTempFiles(request);
            }
            this.flushAndCloseSocket();
        }
        catch (Throwable th) {
            LOG.error("While reading the Request", th);
        }
    }

    private void setupStreams() throws IOException {
        this._is = new BufferedInputStream(this._socket.getInputStream());
        this._os = new BufferedOutputStream(this._socket.getOutputStream());
        this._writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this._os)));
    }

    private void flushAndCloseSocket() throws IOException {
        if (!this._socket.isClosed()) {
            this._socket.getOutputStream().flush();
            this._socket.close();
        }
    }

    private void deleteTempFiles(Request request) {
        RecievedData[] recievedData = request.getRecievedData();
        for (int i = 0; i < recievedData.length; ++i) {
            if (recievedData[i].type() != RecievedData.TYPE_FILE) continue;
            ((RecievedFile)recievedData[i]).deleteTmpFile();
        }
    }

    private FirstLine tokenizeFirstLine(String req) {
        FirstLine fl = new FirstLine();
        StringTokenizer st = new StringTokenizer(req);
        if (st.hasMoreTokens()) {
            fl.method = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            fl.requestString = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            fl.protocoll = st.nextToken().trim();
        }
        return fl;
    }

    private Request fillRequest(FirstLine fl) throws Throwable {
        List<String> headers = this.readHeaders(this._is);
        boolean hasContent = false;
        for (String string : headers) {
            if (!string.startsWith("Content-Length:")) continue;
            hasContent = Utils.parseLong(string) > 0L;
            break;
        }
        Request request = new Request();
        request.setMethod(fl.method);
        request.setRequestString(fl.requestString);
        request.setProtocoll(fl.protocoll);
        request.setClient(this._socket.getInetAddress());
        for (String headerLine : headers) {
            request.addHeaderLine(headerLine);
        }
        if (hasContent) {
            String string = request.getHeaderValue("Content-Length");
            if (this.checkUpload(request)) {
                this.fillUpPost(request, this._is, string);
            } else {
                String domainname = request.getHost();
                this.sendDoc(new ErrorDoc("data segment too large"), domainname);
                this._socket.close();
            }
        }
        return request;
    }

    private List<String> readHeaders(BufferedInputStream is) throws IOException {
        ArrayList<String> headers = new ArrayList<String>();
        String headerline = Utils.readUntilNewLine(is, true);
        while (!headerline.equals("")) {
            LOG.info(headerline);
            headers.add(headerline);
            headerline = Utils.readUntilNewLine(is, true);
        }
        return headers;
    }

    private boolean checkUpload(Request request) {
        String plainreq = request.getReqestString();
        WebApp wa = this._webAppHandler.getWebApp(request);
        if (wa == null) {
            return false;
        }
        String postingSizeStr = request.getHeaderValue("Content-Length");
        if (postingSizeStr == null) {
            return false;
        }
        Long postingSizeLong = new Long(postingSizeStr);
        long actual = postingSizeLong;
        long max = wa.maxPostingSize(plainreq);
        if (max == -1L) {
            return true;
        }
        return actual <= max;
    }

    private void fillUpPost(Request request, BufferedInputStream is, String lengthString) throws IOException {
        lengthString = lengthString.trim();
        long length = Utils.parseLong(lengthString);
        String contentType = request.getHeaderValue("Content-Type");
        String charset = "UTF-8";
        StringTokenizer st = new StringTokenizer(contentType, ";");
        contentType = st.nextToken();
        if (st.hasMoreElements()) {
            String tmpCharSet = st.nextToken();
            if ((st = new StringTokenizer(tmpCharSet, "=")).hasMoreElements()) {
                st.nextToken();
            }
            if (st.hasMoreElements()) {
                charset = st.nextToken();
            }
        }
        if (contentType.equals(Request.CONTENT_TYPE_APPLICATION)) {
            request.apendURLEncoded(is, length);
        } else if (contentType.startsWith(Request.CONTENT_TYPE_MULTIPART)) {
            request.apendMultipart(is, length);
        } else if (contentType.startsWith(Request.CONTENT_TYPE_XML)) {
            request.apendXML(is, charset, length);
        } else if (contentType.equalsIgnoreCase(Request.CONTENT_TYPE_JSON)) {
            request.apendJSON(is, charset, length);
        } else if (contentType.equalsIgnoreCase(Request.CONTENT_TYPE_JSON_PATCH)) {
            request.apendJSONArray(is, charset, length);
        } else {
            request.appendSinglePart(is, length);
        }
    }

    private void switchNow(Request request) {
        WebApp app = this._webAppHandler.getWebApp(request);
        String domainname = request.getHost();
        if (app == null) {
            this.sendDoc(new ErrorDoc("unknown domainname: " + domainname), domainname);
            LOG.info(LogMarker.CONNECTION, "unknown domainName: " + domainname);
            return;
        }
        WebDoc doc = null;
        try {
            doc = app.process(request);
            this.sendDoc(doc, domainname);
            LOG.info(LogMarker.responseMarker(domainname), request.getReqestString() + " " + doc.size() + "bytes");
            request.cleanup();
        }
        catch (Throwable th) {
            LOG.error(LogMarker.CONNECTION, "Error in the WebApp " + app.toString(), th);
            this.sendDoc(new ErrorDoc("Error in the WebApp " + app.toString() + "\n" + th.toString()), domainname);
        }
    }

    private void sendDoc(WebDoc doc, String domainname) {
        try {
            this.sendHeader(doc);
            if (doc.dataType().equals("BYTE")) {
                this._os.write(doc.byteData());
            } else {
                int len;
                BufferedInputStream is = new BufferedInputStream(doc.streamData());
                byte[] buffer = new byte[4096];
                while ((len = is.read(buffer)) != -1) {
                    this._os.write(buffer, 0, len);
                }
            }
            this._os.flush();
            doc.close();
        }
        catch (Throwable th) {
            LOG.error(LogMarker.CONNECTION, "while sending Data to the Browser", th);
        }
    }

    private void sendHeader(WebDoc doc) throws Throwable {
        this._writer.println("HTTP/1.1 " + doc.getHttpCode().code + " " + doc.getHttpCode().message);
        this._writer.println("Connection: Close");
        this._writer.println("Access-Control-Allow-Origin: *");
        this._writer.println("Access-Control-Allow-Methods: POST, GET, DELETE, PUT, PATCH, HEAD, OPTIONS");
        this._writer.println("Access-Control-Allow-Headers: X-PINGOTHER, Content-Type, Authorization, Test");
        this._writer.println("Server: SimpleFlex base V2.2.2");
        this._writer.println("Date: " + Utils.getHTTPDateHeaderValue(new Date()));
        this._writer.println("Content-Type: " + doc.mime());
        this._writer.println("Content-length: " + doc.size());
        for (HeaderField header : doc.getHeaders()) {
            this._writer.println(header.name() + " " + header.value());
        }
        this._writer.println("");
        this._writer.flush();
    }

    private void sendHeaderNotSupported() {
        this._writer.println("HTTP/1.1 501 Not Implemented");
        this._writer.println();
        this._writer.flush();
    }

    private void sendOptionsHeader() {
        LOG.info("Sending OPTION Response");
        this._writer.println("HTTP/1.1 200 OK");
        this._writer.println("Connection: Close");
        this._writer.println("Server: SimpleFlex base V2.2.2");
        this._writer.println("Date: " + Utils.getHTTPDateHeaderValue(new Date()));
        this._writer.println("Content-Type: application/json");
        this._writer.println("Access-Control-Allow-Origin: *");
        this._writer.println("Access-Control-Allow-Methods: POST, GET, DELETE, PUT, PATCH, HEAD, OPTIONS");
        this._writer.println("Access-Control-Allow-Headers: X-PINGOTHER, Content-Type, Authorization, Test");
        this._writer.println("Content-length: 0");
        this._writer.println();
        this._writer.flush();
    }

    private class FirstLine {
        public String method = null;
        public String requestString = null;
        public String protocoll = null;

        private FirstLine() {
        }

        public boolean valid() {
            boolean valid;
            boolean bl = valid = this.method != null && this.requestString != null && this.protocoll != null;
            if (valid) {
                valid = this.method.equals("POST") || this.method.equals("GET") || this.method.equals("OPTIONS") || this.method.equals("DELETE") || this.method.equals("PATCH") || this.method.equals("PUT");
            }
            return valid;
        }
    }
}

