/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UntilNewlineReader {
    private InputStream _is;
    private byte[] _buffer;
    private int _inBufferStart = -1;
    private int _inBufferSize = -1;

    public UntilNewlineReader(InputStream is, int buffersize) {
        this._is = is;
        this._buffer = new byte[buffersize];
    }

    public byte[] read() throws IOException {
        byte[] result = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            if (this._inBufferStart >= 0 && this._inBufferSize >= 0) {
                if (this.writeUntilNewline(os, this._inBufferStart, this._inBufferSize)) {
                    byte[] byArray = result = os.toByteArray();
                    return byArray;
                }
                this._inBufferStart = -1;
                this._inBufferSize = -1;
            }
            int length = 0;
            while ((length = this._is.read(this._buffer)) != -1) {
                if (!this.writeUntilNewline(os, 0, length)) continue;
                byte[] byArray = result = os.toByteArray();
                return byArray;
            }
            result = os.toByteArray();
        }
        return result;
    }

    private boolean writeUntilNewline(OutputStream os, int from, int size) throws IOException {
        int i;
        if (size == 0) {
            return false;
        }
        boolean newlineFound = false;
        for (i = from; i < from + size; ++i) {
            if ((char)this._buffer[i] != '\n') continue;
            newlineFound = true;
            this._inBufferStart = i + 1;
            this._inBufferSize = from + size - this._inBufferStart;
            break;
        }
        int to = i - from + 1;
        if (!newlineFound) {
            to = size;
        }
        os.write(this._buffer, from, to);
        return newlineFound;
    }
}

