/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.conf.text;

import ch.software_atelier.simpleflex.conf.ConfigGenerator;
import ch.software_atelier.simpleflex.conf.DomainConfig;
import ch.software_atelier.simpleflex.conf.GlobalConfig;
import ch.software_atelier.simpleflex.conf.WebAppConfig;
import ch.software_atelier.simpleflex.conf.text.ConfigElement;
import ch.software_atelier.simpleflex.conf.text.ConfigFileIO;
import ch.software_atelier.simpleflex.conf.text.SyntaxErrorNotifiable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SimpleFlexConfigGenerator
implements SyntaxErrorNotifiable,
ConfigGenerator {
    private static final String GC_DEFLOGPATH = "DEFLOGPATH";
    private static final String GC_PORT = "PORT";
    private static final String GC_SSLPORT = "SSLPORT";
    private static final String GC_SSLKEYSTORE = "SSLKEYSTORE";
    private static final String GC_SSLKEYSTOREPASSWORD = "SSLKEYSTOREPASSWORD";
    private static final String GC_USESSL = "USESSL";
    private static final String GC_USESECUTITYMANAGER = "SECURITYMANAGER";
    private static final String GC_USEFILEINTERFACE = "FILEINTERFACE";
    private static final String DOMAIN_NAME = "NAME";
    private static final String DOMAIN_DOCPATH = "DOCPATH";
    private static final String DOMAIN_CONFIG = "CONFIG";
    private static final String LOG_CLASSPATH = "CLASSPATH";
    private static final String WEBAPP_CLASSPATH = "CLASSPATH";
    private static final String WEBAPP_NAME = "NAME";
    private static final String FILEINTERFACE_FILE = "FILE";
    private static final String FILEINTERFACE_INTERVAL = "INTERVAL";
    private static final String ELEM_WEBAPP = "WebApp";
    private static final String ELEM_DEFWEBAPP = "DefaultWebApp";
    private static final String ELEM_DOMAIN = "Domain";
    private static final String ELEM_GLOBAL = "Global";
    private static final String ELEM_FILEINTERFACE = "FileInterface";
    private static final String ELEM_LIB = "Library";
    private GlobalConfig _globalConfig = new GlobalConfig();
    private ArrayList _domainConfigs = new ArrayList();

    public SimpleFlexConfigGenerator(File mainconfig) {
        try {
            ConfigFileIO mainConfigIO = new ConfigFileIO(mainconfig, this);
            mainConfigIO.read();
            ConfigElement[] cElems = mainConfigIO.configElements();
            for (int i = 0; i < cElems.length; ++i) {
                if (cElems[i].elementName().equals(ELEM_GLOBAL)) {
                    this.handleGlobalConfig(cElems[i]);
                    continue;
                }
                if (cElems[i].elementName().equals(ELEM_DOMAIN)) {
                    this.handleDomainConfig(cElems[i]);
                    continue;
                }
                if (cElems[i].elementName().equals(ELEM_FILEINTERFACE)) {
                    this.handleFileInterfaceConfig(cElems[i]);
                    continue;
                }
                this.syntaxError("Unsupported Element: <" + cElems[i].elementName() + ">", false);
            }
        }
        catch (IOException ioe) {
            this.syntaxError("Error on reading the main config-files: " + ioe.toString(), true);
        }
    }

    @Override
    public GlobalConfig globalConfig() {
        return this._globalConfig;
    }

    @Override
    public List<DomainConfig> domainConfigs() {
        return this._domainConfigs;
    }

    @Override
    public void syntaxError(String message, boolean fatal) {
        if (fatal) {
            System.out.println("Fatal error in config:");
            System.out.println(message);
            System.exit(1);
        } else {
            System.out.println("Error in config:");
            System.out.println(message);
            System.out.println("SimpleFlex may not work as expected");
        }
    }

    private void handleFileInterfaceConfig(ConfigElement fileInterfaceConfig) {
        String[] interval = fileInterfaceConfig.getValuesByKey(FILEINTERFACE_INTERVAL);
        String[] file = fileInterfaceConfig.getValuesByKey(FILEINTERFACE_FILE);
        if (interval.length == 1) {
            try {
                int interv = Integer.parseInt(interval[0]);
                this._globalConfig.setFileInterfaceInterval(interv);
            }
            catch (NumberFormatException nfe) {
                this.syntaxError("INTERVAL=" + interval[0] + " > invalide value", false);
            }
        } else if (interval.length > 1) {
            this.syntaxError("More Then one INTERVAL key/value-pairs. All ignored!", false);
        }
        if (file.length == 1) {
            File interfaceFile = this.checkFile(file[0]);
            if (file != null) {
                interfaceFile.delete();
                this._globalConfig.setFileInterfaceFile(interfaceFile);
            }
        } else if (file.length > 1) {
            this.syntaxError("More Then one FILE key/value-pairs. All ignored!", false);
        }
    }

    private void handleGlobalConfig(ConfigElement globalConfigElem) {
        int sslportI;
        int portI;
        String[] port = globalConfigElem.getValuesByKey(GC_PORT);
        String[] sslPort = globalConfigElem.getValuesByKey(GC_SSLPORT);
        String[] useSSL = globalConfigElem.getValuesByKey(GC_USESSL);
        String[] sslKeyStore = globalConfigElem.getValuesByKey(GC_SSLKEYSTORE);
        String[] sslPassword = globalConfigElem.getValuesByKey(GC_SSLKEYSTOREPASSWORD);
        String[] useSecManager = globalConfigElem.getValuesByKey(GC_USESECUTITYMANAGER);
        String[] useFileInterface = globalConfigElem.getValuesByKey(GC_USEFILEINTERFACE);
        if (this.checkForValidCount(port, GC_PORT) && (portI = this.positiveIntByString(port[0])) != -1) {
            this._globalConfig.setPort(portI);
        }
        if (this.checkForValidCount(sslPort, GC_SSLPORT) && (sslportI = this.positiveIntByString(sslPort[0])) != -1) {
            this._globalConfig.setSSLPort(sslportI);
        }
        if (this.checkForValidCount(useSSL, GC_USESSL)) {
            this._globalConfig.setUseSSL(useSSL[0].equalsIgnoreCase("yes"));
        }
        if (this.checkForValidCount(useFileInterface, GC_USEFILEINTERFACE)) {
            this._globalConfig.setUseFileInterface(useFileInterface[0].equalsIgnoreCase("yes"));
        }
        if (this.checkForValidCount(sslKeyStore, GC_SSLKEYSTORE)) {
            this._globalConfig.setSSLKeyStore(sslKeyStore[0]);
        }
        if (this.checkForValidCount(sslPassword, GC_SSLKEYSTOREPASSWORD)) {
            this._globalConfig.setSSLKeyStorePassword(sslPassword[0]);
        }
        if (this.checkForValidCount(useSecManager, GC_USESECUTITYMANAGER)) {
            this._globalConfig.setUseSecurityManager(useSecManager[0].equalsIgnoreCase("YES"));
        }
    }

    private WebAppConfig handleWebAppConfig(ConfigElement webAppConfigElem) {
        String[] classPath = webAppConfigElem.getValuesByKey("CLASSPATH");
        String[] name = webAppConfigElem.getValuesByKey("NAME");
        if (this.checkForValidCount(classPath, "CLASSPATH") && this.checkForValidCount(name, "NAME")) {
            WebAppConfig waC = new WebAppConfig(classPath[0], name[0]);
            String[][] waCList = webAppConfigElem.getValuesAndKeysByRegexOfKey("^\\$.*");
            for (int i = 0; i < waCList[0].length; ++i) {
                waC.config().put(waCList[0][i], waCList[1][i]);
            }
            return waC;
        }
        return null;
    }

    private void handleDomainConfig(ConfigElement domainConfigElem) {
        String[] nameA = domainConfigElem.getValuesByKey("NAME");
        String[] configA = domainConfigElem.getValuesByKey(DOMAIN_CONFIG);
        String name = null;
        File config = null;
        if (this.checkForValidCount(nameA, "NAME")) {
            name = nameA[0];
        }
        if (this.checkForValidCount(configA, DOMAIN_CONFIG) && (config = this.checkFile(configA[0])) == null) {
            this.syntaxError("no valid file on CONFIG", false);
        }
        if (name != null || config != null) {
            DomainConfig domainConfig = new DomainConfig(name);
            ConfigFileIO configFileIO = new ConfigFileIO(config, this);
            try {
                configFileIO.read();
                ConfigElement[] configElements = configFileIO.configElements();
                for (int i = 0; i < configElements.length; ++i) {
                    WebAppConfig wac;
                    if (configElements[i].elementName().equals(ELEM_WEBAPP)) {
                        wac = this.handleWebAppConfig(configElements[i]);
                        if (wac != null) {
                            domainConfig.appendWebApp(wac);
                            continue;
                        }
                        this.syntaxError("cant read WebApp-configuration of domain " + name + " - WebApp ignored", false);
                        continue;
                    }
                    if (!configElements[i].elementName().equals(ELEM_DEFWEBAPP)) continue;
                    wac = this.handleWebAppConfig(configElements[i]);
                    if (wac != null) {
                        domainConfig.setDefaultWebAppConfig(wac);
                        continue;
                    }
                    this.syntaxError("cant read Default WebApp-configuration of domain " + name + " - WebApp ignored", false);
                }
                this._domainConfigs.add(domainConfig);
            }
            catch (IOException ioe) {
                this.syntaxError("cant read configuration of host " + name + " - host ignored", false);
            }
        } else {
            this.syntaxError("no valid <Host> element! - ignored", false);
        }
    }

    private void invalideKeyValue(String key) {
        this.syntaxError("invalide: " + key + ", using default value", false);
    }

    private File checkFile(String fileStr) {
        try {
            File file = new File(fileStr);
            if (file.exists()) {
                if (file.canWrite() && file.canRead() && file.isFile()) {
                    return file;
                }
                return null;
            }
            if (file.createNewFile()) {
                return file;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private int positiveIntByString(String integer) {
        try {
            Integer i = new Integer(integer);
            if (i > 0) {
                return i;
            }
            return -1;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private boolean checkForValidCount(String[] values, String key) {
        if (values.length == 1) {
            return true;
        }
        if (values.length == 0) {
            return false;
        }
        this.invalideKeyValue(key);
        return false;
    }
}

