/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest.swagger;

import org.json.JSONArray;
import org.json.JSONObject;

public class ObjectSchemaBuilder {
    private JSONObject _data = new JSONObject();

    private ObjectSchemaBuilder(String description) {
        this._data.put("description", (Object)description);
        this._data.put("type", (Object)"object");
        this._data.put("properties", (Object)new JSONObject());
        this._data.put("required", (Object)new JSONArray());
    }

    public static ObjectSchemaBuilder create(String description) {
        return new ObjectSchemaBuilder(description);
    }

    public ObjectSchemaBuilder addSimpleProperty(String name, String type, String description, boolean required) {
        JSONObject obj = new JSONObject();
        obj.put("description", (Object)description);
        obj.put("type", (Object)type);
        this._data.getJSONObject("properties").put(name, (Object)obj);
        if (required) {
            this._data.getJSONArray("required").put((Object)name);
        }
        return this;
    }

    public ObjectSchemaBuilder addObjectProperty(String name, JSONObject object, boolean required) {
        this._data.getJSONObject("properties").put(name, (Object)object);
        if (required) {
            this._data.getJSONArray("required").put((Object)name);
        }
        return this;
    }

    public JSONObject toJSON() {
        return this._data;
    }
}

