/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest;

import ch.software_atelier.simpleflex.Request;
import ch.software_atelier.simpleflex.Utils;
import ch.software_atelier.simpleflex.docs.WebDoc;
import ch.software_atelier.simpleflex.rest.RestException;
import ch.software_atelier.simpleflex.rest.RestHlp;
import ch.software_atelier.simpleflex.rest.RestRequest;
import ch.software_atelier.simpleflex.rest.RestResource;
import ch.software_atelier.simpleflex.rest.RestResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestHandler {
    private final String _appName;
    private final List<String> _resourcePaths = new ArrayList<String>();
    private final List<RestResource> _resources = new ArrayList<RestResource>();
    static Logger LOG = LogManager.getLogger(RestHandler.class);

    public RestHandler(String appName) {
        this._appName = appName;
    }

    public WebDoc handle(Request r) {
        try {
            int index = this.getPathIndex(r);
            RestResource resource = this._resources.get(index);
            RestRequest req = new RestRequest(r, this._appName, this._resourcePaths.get(index));
            try {
                if (r.getMethod().equalsIgnoreCase("DELETE")) {
                    return resource.onDELETE(req);
                }
                if (r.getMethod().equalsIgnoreCase("GET")) {
                    return resource.onGET(req);
                }
                if (r.getMethod().equalsIgnoreCase("OPTIONS")) {
                    return resource.onOPTIONS(req);
                }
                if (r.getMethod().equalsIgnoreCase("PATCH")) {
                    return resource.onPATCH(req);
                }
                if (r.getMethod().equalsIgnoreCase("POST")) {
                    return resource.onPOST(req);
                }
                if (r.getMethod().equalsIgnoreCase("PUT")) {
                    return resource.onPUT(req);
                }
            }
            catch (RestException re) {
                LOG.error("", (Throwable)re);
                return RestResponse.error(re.getErrorCode(), re.getErrorMsg(), re.getBodyMsg());
            }
        }
        catch (Throwable th) {
            LOG.error("", th);
        }
        return RestResponse.notFound_404();
    }

    public boolean handles(Request r) {
        return this.getPathIndex(r) >= 0;
    }

    private int getPathIndex(Request r) {
        List<String> nodes = RestHlp.getResourceNodes(r, this._appName);
        for (int i = 0; i < this._resourcePaths.size(); ++i) {
            String path = this._resourcePaths.get(i);
            List templateNodes = Utils.tokenize((String)path, (String)"/");
            if (nodes.size() != templateNodes.size() && !((String)templateNodes.get(templateNodes.size() - 1)).endsWith("*}")) continue;
            boolean handles = true;
            for (int ii = 0; ii < templateNodes.size(); ++ii) {
                String expected = (String)templateNodes.get(ii);
                String found = "/";
                if (nodes.size() - 1 >= ii) {
                    found = nodes.get(ii);
                }
                if (expected.startsWith("{") && expected.endsWith("*}")) {
                    return i;
                }
                boolean bl = handles = handles && (expected.equals(found) || expected.startsWith("{") && expected.endsWith("}"));
                if (!handles) break;
            }
            if (!handles) continue;
            return i;
        }
        return -1;
    }

    public void registerResource(String resourcePath, RestResource resource) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        this._resourcePaths.add(resourcePath);
        this._resources.add(resource);
    }
}

