/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest;

import ch.software_atelier.simpleflex.HTTPCodes;
import ch.software_atelier.simpleflex.Utils;
import ch.software_atelier.simpleflex.docs.HeaderField;
import ch.software_atelier.simpleflex.docs.WebDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestResponse
extends WebDoc {
    private int _httpCode = 200;
    private String _httpMsg = "OK";
    private String _name;
    private String _mimeType;
    private byte[] _content = null;
    private InputStream _streamContent = null;
    private File _tmpFile = null;
    private long _streamLength;

    public static RestResponse json_200(JSONObject obj) {
        return new RestResponse("data.json", "application/json", obj.toString().getBytes());
    }

    public static RestResponse json_200(JSONArray obj) {
        return new RestResponse("data.json", "application/json", obj.toString().getBytes());
    }

    public static RestResponse json_201_created(JSONObject obj) {
        RestResponse response = new RestResponse("data.json", "application/json", obj.toString().getBytes());
        response.setHTTPCode(201, "Created");
        return response;
    }

    public static RestResponse json_201_created(JSONArray obj) {
        RestResponse response = new RestResponse("data.json", "application/json", obj.toString().getBytes());
        response.setHTTPCode(201, "Created");
        return response;
    }

    public static RestResponse notFound_404() {
        return RestResponse.error(404, "File Not Found", "This resource was not found on this server");
    }

    public static RestResponse methodNotAllewed_405() {
        return RestResponse.error(405, "Method Not Allowed", "This method is not allowed on this resource");
    }

    public static RestResponse badRequest_400(Object msg) {
        return RestResponse.error(400, "Bad Request", msg);
    }

    public static RestResponse unauthorized_401() {
        return RestResponse.error(401, "Unauthorized", "Authorisation failed");
    }

    public static RestResponse noContent_204() {
        return RestResponse.error(204, HTTPCodes.getMsg((int)204), null);
    }

    public static RestResponse internalServerError_500(Object msg) {
        return RestResponse.error(500, "Internal Server Error", msg);
    }

    public static RestResponse error(int errCode, String errMsg, Object msg) {
        String payload = msg == null ? "" : (msg instanceof JSONObject ? "{\"msg\":" + msg.toString() + "}" : "{\"msg\":\"" + msg + "\"}");
        RestResponse response = new RestResponse("err.htm", Utils.getMime((String)"json"), payload.getBytes());
        response.setHTTPCode(errCode, errMsg);
        return response;
    }

    public RestResponse(String name, String mime, byte[] content) {
        this._name = name;
        this._mimeType = mime;
        this._content = content;
    }

    public RestResponse(String name, String mime, InputStream content, long size) {
        this._name = name;
        this._mimeType = mime;
        this._streamContent = content;
        this._streamLength = size;
    }

    public RestResponse(String name, String mime, File file, boolean isTemporary) throws FileNotFoundException {
        this._name = name;
        this._mimeType = mime;
        this._streamContent = new FileInputStream(file);
        this._streamLength = file.length();
        if (isTemporary) {
            this._tmpFile = file;
        }
    }

    public void addHeader(String name, String value) {
        this.getHeaders().add(new HeaderField(name, value));
    }

    public long size() {
        if (this._content != null) {
            return this._content.length;
        }
        return this._streamLength;
    }

    public String mime() {
        return this._mimeType;
    }

    public String name() {
        return this._name;
    }

    public byte[] byteData() {
        return this._content;
    }

    public InputStream streamData() {
        return this._streamContent;
    }

    public String dataType() {
        if (this._content != null) {
            return "BYTE";
        }
        return "STREAM";
    }

    public void close() {
        if (this._streamContent != null) {
            try {
                this._streamContent.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this._tmpFile != null && !this._tmpFile.delete()) {
            this._tmpFile.deleteOnExit();
        }
    }
}

