/*
 * Decompiled with CFR 0.152.
 */
package ch.software_atelier.simpleflex.rest;

import ch.software_atelier.simpleflex.RecievedData;
import ch.software_atelier.simpleflex.RecievedFile;
import ch.software_atelier.simpleflex.RecievedText;
import ch.software_atelier.simpleflex.Request;
import ch.software_atelier.simpleflex.Utils;
import ch.software_atelier.simpleflex.rest.RestHlp;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import xmlwise.XmlElement;

public class RestRequest {
    private Request _request;
    private String _appName;
    private String _resourcePattern;

    public RestRequest(Request r, String appName, String resourcePattern) {
        this._request = r;
        this._resourcePattern = resourcePattern;
        this._appName = appName;
    }

    public String getPath() {
        if (this._appName.length() == 0) {
            return this._request.getReqestString();
        }
        return this._request.getReqestString().substring(this._appName.length() + 1);
    }

    public String getResourcePlaceholder(String name) {
        List<String> resurcePath = RestHlp.getResourceNodes(this._request, this._appName);
        List patternPath = Utils.tokenize((String)this._resourcePattern, (String)"/");
        for (int i = 0; i < patternPath.size(); ++i) {
            String patternNode = (String)patternPath.get(i);
            if (patternNode.equals("{" + name + "}")) {
                return resurcePath.get(i);
            }
            if (!patternNode.equals("{" + name + "*}")) continue;
            String path = "";
            for (int ii = i; ii < resurcePath.size(); ++ii) {
                path = path + "/" + resurcePath.get(ii);
            }
            return path;
        }
        return null;
    }

    public String getRequestArgument(String name) {
        return this._request.getArgument(name);
    }

    public HashMap<String, String> getheaders() {
        return this._request.getHeaders();
    }

    public String getHeaderValue(String key) {
        return this._request.getHeaderValue(key);
    }

    public boolean isXML() {
        return this._request.isXMLReq();
    }

    public boolean isJSON() {
        return this._request.isJSONReq();
    }

    public boolean isJSONArray() {
        return this._request.isJSONArrReq();
    }

    public JSONArray getJSONArray() {
        return this._request.getJSONArrReq();
    }

    public JSONObject getJSON() {
        return this._request.getJSONReq();
    }

    public XmlElement getXML() {
        return this._request.getXMLReq();
    }

    public boolean isSinglePart() {
        return this._request.isSinglePartReq();
    }

    public byte[] getRawData() {
        return this._request.getRawData();
    }

    public boolean isMultiPart() {
        return this._request.isFormPostReq();
    }

    public String getSinglePartFilename() {
        return this._request.getSinglePartFilename();
    }

    public String getSinglePartMimeType() {
        return this._request.getSinglePartMimeType();
    }

    public File getSinglePartFile() {
        return this._request.getSinglePartFile();
    }

    public File getFile(String fldName) {
        RecievedData[] data;
        for (RecievedData rd : data = this._request.getRecievedData()) {
            if (!rd.fieldName().equals(fldName)) continue;
            if (rd instanceof RecievedFile) {
                return ((RecievedFile)rd).file();
            }
            return null;
        }
        return null;
    }

    public List<String> getFieldNames() {
        RecievedData[] data;
        ArrayList<String> fldNames = new ArrayList<String>();
        for (RecievedData rd : data = this._request.getRecievedData()) {
            fldNames.add(rd.fieldName());
        }
        return fldNames;
    }

    public byte[] getData(String fldName) {
        RecievedData[] data;
        for (RecievedData rd : data = this._request.getRecievedData()) {
            if (!rd.fieldName().equals(fldName)) continue;
            if (rd instanceof RecievedFile) {
                return ((RecievedFile)rd).getData();
            }
            if (!(rd instanceof RecievedText)) continue;
            return ((RecievedText)rd).getURLDecodedText().getBytes();
        }
        return null;
    }

    public String getFileName(String fldName) {
        RecievedData[] data;
        for (RecievedData rd : data = this._request.getRecievedData()) {
            if (!rd.fieldName().equals(fldName)) continue;
            if (rd instanceof RecievedFile) {
                return ((RecievedFile)rd).fileName();
            }
            return null;
        }
        return null;
    }
}

