/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.redis;

import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.OrchestraClusterName;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.ShardId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/redis/RedisKeyFactory;", "", "applicationName", "", "streamName", "(Ljava/lang/String;Ljava/lang/String;)V", "clusterName", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/OrchestraClusterName;", "(Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/OrchestraClusterName;)V", "shardFinishedKeyBase", "shardProgressKeyBase", "createDeploymentLockKey", "createMergeParentReadyToReshardKey", "parentShardId", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/ShardId;", "childShardId", "createMergeParentReadyToReshardKeyWildcard", "createShardFinishedKey", "shardId", "createShardProgressFlagKey", "createShardSequenceNumberKey", "vertx-kinesis-consumer-orchestra"})
public final class RedisKeyFactory {
    private final String shardFinishedKeyBase;
    private final String shardProgressKeyBase;
    private final OrchestraClusterName clusterName;

    @NotNull
    public final String createShardProgressFlagKey(@NotNull ShardId shardId2) {
        Intrinsics.checkNotNullParameter((Object)shardId2, (String)"shardId");
        return this.shardProgressKeyBase + shardId2;
    }

    @NotNull
    public final String createShardSequenceNumberKey(@NotNull ShardId shardId2) {
        Intrinsics.checkNotNullParameter((Object)shardId2, (String)"shardId");
        return this.clusterName + "-sequence-" + shardId2;
    }

    @NotNull
    public final String createShardFinishedKey(@NotNull ShardId shardId2) {
        Intrinsics.checkNotNullParameter((Object)shardId2, (String)"shardId");
        return this.shardFinishedKeyBase + shardId2;
    }

    @NotNull
    public final String createDeploymentLockKey() {
        return this.clusterName + "-deployment-lock";
    }

    @NotNull
    public final String createMergeParentReadyToReshardKey(@NotNull ShardId parentShardId, @NotNull ShardId childShardId) {
        Intrinsics.checkNotNullParameter((Object)parentShardId, (String)"parentShardId");
        Intrinsics.checkNotNullParameter((Object)childShardId, (String)"childShardId");
        return this.clusterName + "-ready-for-merge-" + childShardId + '-' + parentShardId;
    }

    @NotNull
    public final String createMergeParentReadyToReshardKeyWildcard(@NotNull ShardId childShardId) {
        Intrinsics.checkNotNullParameter((Object)childShardId, (String)"childShardId");
        return this.clusterName + "-ready-for-merge-" + childShardId + "-*";
    }

    public RedisKeyFactory(@NotNull OrchestraClusterName clusterName) {
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        this.clusterName = clusterName;
        this.shardFinishedKeyBase = this.clusterName + "-finished-";
        this.shardProgressKeyBase = this.clusterName + "-progress-";
    }

    public RedisKeyFactory(@NotNull String applicationName, @NotNull String streamName) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)streamName, (String)"streamName");
        this(new OrchestraClusterName(applicationName, streamName));
    }
}

