/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.consumer.fetching;

import ch.sourcemotion.vertx.kinesis.consumer.orchestra.FetcherOptions;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.consumer.fetching.RecordCountPercentileAverage;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.consumer.fetching.RollingIntList;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.ShardId;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBW\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\u00020\u0016*\u00020\u0007H\u0002J\f\u0010\u001a\u001a\u00020\u0016*\u00020\u0007H\u0002R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lch/sourcemotion/vertx/kinesis/consumer/orchestra/consumer/fetching/GetRecordsLimitAdjustment;", "", "streamName", "", "shardId", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/ShardId;", "initialLimit", "", "getRecordResultsToStartAdjustment", "limitIncreaseStep", "limitDecreaseStep", "limitIncreaseThreshold", "limitDecreaseThreshold", "minimalLimit", "percentile", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/consumer/fetching/RecordCountPercentileAverage;", "(Ljava/lang/String;Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/ShardId;IIIIIIILch/sourcemotion/vertx/kinesis/consumer/orchestra/consumer/fetching/RecordCountPercentileAverage;)V", "currentLimit", "recordCountList", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/consumer/fetching/RollingIntList;", "calculateNextLimit", "includeResponse", "", "getRecordsResponse", "Lsoftware/amazon/awssdk/services/kinesis/model/GetRecordsResponse;", "decreaseThresholdExceeded", "increaseThresholdExceeded", "Companion", "vertx-kinesis-consumer-orchestra"})
public final class GetRecordsLimitAdjustment {
    private int currentLimit;
    private final RollingIntList recordCountList;
    private final String streamName;
    private final ShardId shardId;
    private final int limitIncreaseStep;
    private final int limitDecreaseStep;
    private final int limitIncreaseThreshold;
    private final int limitDecreaseThreshold;
    private final int minimalLimit;
    private final RecordCountPercentileAverage percentile;
    public static final int MAX_ALLOWED_LIMIT = 10000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean includeResponse(@NotNull GetRecordsResponse getRecordsResponse) {
        Intrinsics.checkNotNullParameter((Object)getRecordsResponse, (String)"getRecordsResponse");
        return this.recordCountList.add(getRecordsResponse.records().size());
    }

    public final int calculateNextLimit() {
        if (this.recordCountList.getFull()) {
            int calculatedPercentileOrAverage = this.percentile.calculatePercentileAverage(this.recordCountList);
            if (this.increaseThresholdExceeded(calculatedPercentileOrAverage)) {
                if (this.currentLimit + this.limitIncreaseStep <= 10000) {
                    this.currentLimit += this.limitIncreaseStep;
                    Companion.getLogger().info((Function0)new Function0<Object>(this){
                        final /* synthetic */ GetRecordsLimitAdjustment this$0;

                        @Nullable
                        public final Object invoke() {
                            return "Current get records limit increased to \"" + GetRecordsLimitAdjustment.access$getCurrentLimit$p(this.this$0) + "\" on stream \"" + GetRecordsLimitAdjustment.access$getStreamName$p(this.this$0) + "\" / shard \"" + GetRecordsLimitAdjustment.access$getShardId$p(this.this$0) + '\"';
                        }
                        {
                            this.this$0 = getRecordsLimitAdjustment;
                            super(0);
                        }
                    });
                } else if (this.currentLimit < 10000) {
                    this.currentLimit = 10000;
                    Companion.getLogger().info((Function0)new Function0<Object>(this){
                        final /* synthetic */ GetRecordsLimitAdjustment this$0;

                        @Nullable
                        public final Object invoke() {
                            return "Current get records limit increased to allowed maximum \"" + GetRecordsLimitAdjustment.access$getCurrentLimit$p(this.this$0) + "\" on stream \"" + GetRecordsLimitAdjustment.access$getStreamName$p(this.this$0) + "\" / shard \"" + GetRecordsLimitAdjustment.access$getShardId$p(this.this$0) + '\"';
                        }
                        {
                            this.this$0 = getRecordsLimitAdjustment;
                            super(0);
                        }
                    });
                }
            } else if (this.decreaseThresholdExceeded(calculatedPercentileOrAverage)) {
                if (this.currentLimit - this.limitDecreaseStep >= this.minimalLimit) {
                    this.currentLimit -= this.limitDecreaseStep;
                    Companion.getLogger().info((Function0)new Function0<Object>(this){
                        final /* synthetic */ GetRecordsLimitAdjustment this$0;

                        @Nullable
                        public final Object invoke() {
                            return "Current get records limit decreased to \"" + GetRecordsLimitAdjustment.access$getCurrentLimit$p(this.this$0) + "\" on stream \"" + GetRecordsLimitAdjustment.access$getStreamName$p(this.this$0) + "\" / shard \"" + GetRecordsLimitAdjustment.access$getShardId$p(this.this$0) + '\"';
                        }
                        {
                            this.this$0 = getRecordsLimitAdjustment;
                            super(0);
                        }
                    });
                } else if (this.currentLimit > this.minimalLimit) {
                    this.currentLimit = this.minimalLimit;
                    Companion.getLogger().info((Function0)new Function0<Object>(this){
                        final /* synthetic */ GetRecordsLimitAdjustment this$0;

                        @Nullable
                        public final Object invoke() {
                            return "Current get records limit decreased to configured minimum \"" + GetRecordsLimitAdjustment.access$getMinimalLimit$p(this.this$0) + "\" on stream \"" + GetRecordsLimitAdjustment.access$getStreamName$p(this.this$0) + "\" / shard \"" + GetRecordsLimitAdjustment.access$getShardId$p(this.this$0) + '\"';
                        }
                        {
                            this.this$0 = getRecordsLimitAdjustment;
                            super(0);
                        }
                    });
                }
            }
        }
        return this.currentLimit;
    }

    private final boolean increaseThresholdExceeded(int $this$increaseThresholdExceeded) {
        return $this$increaseThresholdExceeded > this.currentLimit - this.limitIncreaseThreshold;
    }

    private final boolean decreaseThresholdExceeded(int $this$decreaseThresholdExceeded) {
        return $this$decreaseThresholdExceeded < this.minimalLimit || $this$decreaseThresholdExceeded < this.currentLimit - this.limitDecreaseThreshold;
    }

    private GetRecordsLimitAdjustment(String streamName, ShardId shardId2, int initialLimit, int getRecordResultsToStartAdjustment, int limitIncreaseStep, int limitDecreaseStep, int limitIncreaseThreshold, int limitDecreaseThreshold, int minimalLimit, RecordCountPercentileAverage percentile) {
        this.streamName = streamName;
        this.shardId = shardId2;
        this.limitIncreaseStep = limitIncreaseStep;
        this.limitDecreaseStep = limitDecreaseStep;
        this.limitIncreaseThreshold = limitIncreaseThreshold;
        this.limitDecreaseThreshold = limitDecreaseThreshold;
        this.minimalLimit = minimalLimit;
        this.percentile = percentile;
        this.currentLimit = initialLimit;
        this.recordCountList = new RollingIntList(getRecordResultsToStartAdjustment);
    }

    public static final /* synthetic */ int access$getCurrentLimit$p(GetRecordsLimitAdjustment $this) {
        return $this.currentLimit;
    }

    public static final /* synthetic */ void access$setCurrentLimit$p(GetRecordsLimitAdjustment $this, int n) {
        $this.currentLimit = n;
    }

    public static final /* synthetic */ String access$getStreamName$p(GetRecordsLimitAdjustment $this) {
        return $this.streamName;
    }

    public static final /* synthetic */ ShardId access$getShardId$p(GetRecordsLimitAdjustment $this) {
        return $this.shardId;
    }

    public static final /* synthetic */ int access$getMinimalLimit$p(GetRecordsLimitAdjustment $this) {
        return $this.minimalLimit;
    }

    public /* synthetic */ GetRecordsLimitAdjustment(String streamName, ShardId shardId2, int initialLimit, int getRecordResultsToStartAdjustment, int limitIncreaseStep, int limitDecreaseStep, int limitIncreaseThreshold, int limitDecreaseThreshold, int minimalLimit, RecordCountPercentileAverage percentile, DefaultConstructorMarker $constructor_marker) {
        this(streamName, shardId2, initialLimit, getRecordResultsToStartAdjustment, limitIncreaseStep, limitDecreaseStep, limitIncreaseThreshold, limitDecreaseThreshold, minimalLimit, percentile);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lch/sourcemotion/vertx/kinesis/consumer/orchestra/consumer/fetching/GetRecordsLimitAdjustment$Companion;", "Lmu/KLogging;", "()V", "MAX_ALLOWED_LIMIT", "", "withOptions", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/consumer/fetching/GetRecordsLimitAdjustment;", "streamName", "", "shardId", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/ShardId;", "options", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/FetcherOptions;", "vertx-kinesis-consumer-orchestra"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final GetRecordsLimitAdjustment withOptions(@NotNull String streamName, @NotNull ShardId shardId2, @NotNull FetcherOptions options2) {
            Intrinsics.checkNotNullParameter((Object)streamName, (String)"streamName");
            Intrinsics.checkNotNullParameter((Object)shardId2, (String)"shardId");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            return new GetRecordsLimitAdjustment(streamName, shardId2, options2.getGetRecordsLimit(), options2.getDynamicLimitAdjustment().getGetRecordResultsToStartAdjustment(), options2.getDynamicLimitAdjustment().getLimitIncreaseStep(), options2.getDynamicLimitAdjustment().getLimitDecreaseStep(), options2.getDynamicLimitAdjustment().getLimitIncreaseThreshold(), options2.getDynamicLimitAdjustment().getLimitDecreaseThreshold(), options2.getDynamicLimitAdjustment().getMinimalLimit(), new RecordCountPercentileAverage(options2.getDynamicLimitAdjustment().getLimitAdjustmentPercentileOrAverage()), null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

